/*
 * Decompiled with CFR 0.152.
 */
package picocontainer.lifecycle;

import picocontainer.ComponentFactory;
import picocontainer.PicoContainer;
import picocontainer.PicoInstantiationException;
import picocontainer.PicoIntrospectionException;
import picocontainer.defaults.DefaultComponentFactory;
import picocontainer.defaults.NullContainer;
import picocontainer.hierarchical.HierarchicalPicoContainer;
import picocontainer.lifecycle.Disposable;
import picocontainer.lifecycle.Startable;
import picocontainer.lifecycle.Stoppable;

public class LifecyclePicoContainer
extends HierarchicalPicoContainer
implements Startable,
Stoppable,
Disposable {
    private Startable startableAggregatedComponent;
    private Stoppable stoppableAggregatedComponent;
    private Disposable disposableAggregatedComponent;
    private boolean started;
    private boolean disposed;

    public LifecyclePicoContainer(ComponentFactory componentFactory, PicoContainer parentContainer) {
        super(componentFactory, parentContainer);
    }

    public void instantiateComponents() throws PicoInstantiationException, PicoIntrospectionException {
        super.instantiateComponents();
        try {
            this.startableAggregatedComponent = (Startable)this.getAggregateComponentProxy(true, false);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            this.stoppableAggregatedComponent = (Stoppable)this.getAggregateComponentProxy(false, false);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        try {
            Object o = this.getAggregateComponentProxy(false, false);
            this.disposableAggregatedComponent = (Disposable)o;
        }
        catch (ClassCastException e) {
            System.out.println("");
        }
    }

    public void start() throws Exception {
        this.checkDisposed();
        if (this.started) {
            throw new IllegalStateException("Already started.");
        }
        this.started = true;
        if (this.startableAggregatedComponent != null) {
            this.startableAggregatedComponent.start();
        }
    }

    public void stop() throws Exception {
        this.checkDisposed();
        if (!this.started) {
            throw new IllegalStateException("Already stopped.");
        }
        this.started = false;
        if (this.stoppableAggregatedComponent != null) {
            this.stoppableAggregatedComponent.stop();
        }
    }

    public void dispose() throws Exception {
        this.checkDisposed();
        this.disposed = true;
        if (this.disposableAggregatedComponent != null) {
            this.disposableAggregatedComponent.dispose();
        }
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Components Disposed Of");
        }
    }

    public static class Default
    extends LifecyclePicoContainer {
        public Default() {
            super(new DefaultComponentFactory(), new NullContainer());
        }
    }
}

