/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.NoPicoSuitableConstructorException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.internals.ComponentFactory;
import org.picocontainer.internals.ComponentSpecification;

public class DefaultComponentFactory
implements ComponentFactory,
Serializable {
    public Object createComponent(ComponentSpecification componentSpec, Object[] instanceDependencies) throws PicoInvocationTargetInitializationException, NoPicoSuitableConstructorException {
        try {
            Constructor constructor = this.getConstructor(componentSpec.getComponentImplementation());
            return constructor.newInstance(instanceDependencies);
        }
        catch (InvocationTargetException e) {
            throw new PicoInvocationTargetInitializationException(e.getCause());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public Class[] getDependencies(Class componentImplementation) throws PicoIntrospectionException {
        Constructor constructor = this.getConstructor(componentImplementation);
        return constructor.getParameterTypes();
    }

    private Constructor getConstructor(Class componentImplementation) throws NoPicoSuitableConstructorException {
        Constructor<?>[] constructors = componentImplementation.getConstructors();
        Constructor<?> picoConstructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> constructor = constructors[i];
            if (constructor.getParameterTypes().length == 0 && constructors.length != 1) continue;
            if (picoConstructor != null) {
                throw new NoPicoSuitableConstructorException(componentImplementation);
            }
            picoConstructor = constructor;
        }
        if (picoConstructor == null) {
            throw new NoPicoSuitableConstructorException(componentImplementation);
        }
        return picoConstructor;
    }
}

