/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.internals.ComponentRegistry;
import org.picocontainer.internals.ComponentSpecification;

public class DefaultComponentRegistry
implements ComponentRegistry,
Serializable {
    protected final List registeredComponentSpecifications = new ArrayList();
    protected final List orderedComponents = new ArrayList();
    protected final Map componentKeyToInstanceMap = new HashMap();
    protected final Map componentToSpec = new HashMap();

    public void registerComponent(ComponentSpecification compSpec) {
        this.componentToSpec.put(compSpec.getComponentImplementation(), compSpec);
        this.registeredComponentSpecifications.add(compSpec);
    }

    public void unregisterComponent(Object componentKey) {
        Iterator iterator = this.registeredComponentSpecifications.iterator();
        while (iterator.hasNext()) {
            ComponentSpecification currentCompSpec = (ComponentSpecification)iterator.next();
            if (!currentCompSpec.getComponentKey().equals(componentKey)) continue;
            this.registeredComponentSpecifications.remove(currentCompSpec);
            this.componentKeyToInstanceMap.remove(componentKey);
            break;
        }
    }

    public Collection getComponentSpecifications() {
        return this.registeredComponentSpecifications;
    }

    public List getOrderedComponents() {
        return new ArrayList(this.orderedComponents);
    }

    public void addOrderedComponent(Object component) {
        this.orderedComponents.add(component);
    }

    public void putComponent(Object componentKey, Object component) {
        this.componentKeyToInstanceMap.put(componentKey, component);
    }

    public boolean contains(Object componentKey) {
        return this.componentKeyToInstanceMap.containsKey(componentKey);
    }

    public Object getComponentInstance(Object componentKey) {
        return this.componentKeyToInstanceMap.get(componentKey);
    }

    public Set getComponentInstanceKeys() {
        Set types = this.componentKeyToInstanceMap.keySet();
        return Collections.unmodifiableSet(types);
    }

    public Set getComponentInstances() {
        HashSet result = new HashSet();
        result.addAll(this.componentKeyToInstanceMap.values());
        return Collections.unmodifiableSet(result);
    }

    public boolean hasComponentInstance(Object componentKey) {
        return this.componentKeyToInstanceMap.containsKey(componentKey);
    }

    public ComponentSpecification getComponentSpec(Object componentKey) {
        return (ComponentSpecification)this.componentToSpec.get(componentKey);
    }

    public Object findImplementingComponent(Class componentType) throws AmbiguousComponentResolutionException {
        ArrayList found = new ArrayList();
        Iterator iterator = this.getComponentInstanceKeys().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object component = this.getComponentInstance(key);
            if (!componentType.isInstance(component)) continue;
            found.add(key);
        }
        if (found.size() > 1) {
            Object[] ambiguousKeys = found.toArray();
            throw new AmbiguousComponentResolutionException(componentType, ambiguousKeys);
        }
        return found.isEmpty() ? null : this.getComponentInstance(found.get(0));
    }

    public ComponentSpecification findImplementingComponentSpecification(Class componentType) throws AmbiguousComponentResolutionException {
        ArrayList<ComponentSpecification> found = new ArrayList<ComponentSpecification>();
        Iterator iterator = this.getComponentSpecifications().iterator();
        while (iterator.hasNext()) {
            ComponentSpecification componentSpecification = (ComponentSpecification)iterator.next();
            if (!componentType.isAssignableFrom(componentSpecification.getComponentImplementation())) continue;
            found.add(componentSpecification);
        }
        if (found.size() > 1) {
            Object[] foundClasses = new Class[found.size()];
            for (int i = 0; i < foundClasses.length; ++i) {
                foundClasses[i] = ((ComponentSpecification)found.get(i)).getComponentImplementation();
            }
            throw new AmbiguousComponentResolutionException(componentType, foundClasses);
        }
        return found.isEmpty() ? null : (ComponentSpecification)found.get(0);
    }

    public Object createComponent(ComponentSpecification componentSpecification) throws PicoInitializationException {
        if (!this.contains(componentSpecification.getComponentKey())) {
            Object component = componentSpecification.instantiateComponent(this);
            this.addOrderedComponent(component);
            this.putComponent(componentSpecification.getComponentKey(), component);
            return component;
        }
        return this.getComponentInstance(componentSpecification.getComponentKey());
    }
}

