/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.RegistrationPicoContainer;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DefaultComponentFactory;
import org.picocontainer.defaults.DefaultComponentRegistry;
import org.picocontainer.defaults.DefaultCompositeProxyFactory;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.extras.CompositeProxyFactory;
import org.picocontainer.internals.ComponentFactory;
import org.picocontainer.internals.ComponentRegistry;
import org.picocontainer.internals.ComponentSpecification;
import org.picocontainer.internals.Parameter;

public class DefaultPicoContainer
implements RegistrationPicoContainer,
Serializable {
    private final ComponentRegistry componentRegistry;
    private final ComponentFactory componentFactory;
    protected List unmanagedComponents = new ArrayList();
    private boolean initialized;
    private CompositeProxyFactory compositeProxyFactory = new DefaultCompositeProxyFactory();

    public DefaultPicoContainer(ComponentFactory componentFactory, ComponentRegistry componentRegistry) {
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory cannot be null");
        }
        if (componentRegistry == null) {
            throw new NullPointerException("childRegistry cannot be null");
        }
        this.componentFactory = componentFactory;
        this.componentRegistry = componentRegistry;
    }

    public final Object getComponentMulticaster() {
        return this.getComponentMulticaster(true, false);
    }

    public final Object getComponentMulticaster(boolean callInInstantiationOrder, boolean callUnmanagedComponents) {
        List aggregateComponents = this.componentRegistry.getOrderedComponents();
        if (!callUnmanagedComponents) {
            Iterator iterator = this.unmanagedComponents.iterator();
            while (iterator.hasNext()) {
                aggregateComponents.remove(iterator.next());
            }
        }
        return this.compositeProxyFactory.createCompositeProxy(this.getClass().getClassLoader(), aggregateComponents, callInInstantiationOrder);
    }

    public void registerComponent(Object componentKey, Class componentImplementation) throws DuplicateComponentKeyRegistrationException, AssignabilityRegistrationException, NotConcreteRegistrationException, PicoIntrospectionException {
        this.checkConcrete(componentImplementation);
        this.checkTypeCompatibility(componentKey, componentImplementation);
        this.checkKeyDuplication(componentKey);
        this.registerComponent(new ComponentSpecification(this.componentFactory, componentKey, componentImplementation));
    }

    public void registerComponent(Object componentKey, Class componentImplementation, Parameter[] parameters) throws NotConcreteRegistrationException, AssignabilityRegistrationException, DuplicateComponentKeyRegistrationException {
        this.checkConcrete(componentImplementation);
        this.checkTypeCompatibility(componentKey, componentImplementation);
        this.checkKeyDuplication(componentImplementation);
        this.registerComponent(new ComponentSpecification(this.componentFactory, componentKey, componentImplementation, parameters));
    }

    private void registerComponent(ComponentSpecification compSpec) {
        this.componentRegistry.registerComponent(compSpec);
    }

    private void checkKeyDuplication(Object componentKey) throws DuplicateComponentKeyRegistrationException {
        Iterator iterator = this.componentRegistry.getComponentSpecifications().iterator();
        while (iterator.hasNext()) {
            Object key = ((ComponentSpecification)iterator.next()).getComponentKey();
            if (key != componentKey) continue;
            throw new DuplicateComponentKeyRegistrationException(key);
        }
    }

    private void checkTypeCompatibility(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException {
        Class componentType;
        if (componentKey instanceof Class && !(componentType = (Class)componentKey).isAssignableFrom(componentImplementation)) {
            throw new AssignabilityRegistrationException(componentType, componentImplementation);
        }
    }

    private void checkConcrete(Class componentImplementation) throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (componentImplementation.getModifiers() & 0x400) == 1024;
        if (componentImplementation.isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(componentImplementation);
        }
    }

    public void registerComponentByInstance(Object component) throws PicoRegistrationException, PicoIntrospectionException {
        this.registerComponent(component.getClass(), component);
    }

    public void registerComponent(Object componentKey, Object component) throws PicoRegistrationException, PicoIntrospectionException {
        this.checkTypeCompatibility(componentKey, component.getClass());
        this.checkKeyDuplication(componentKey);
        this.registerComponent(new ComponentSpecification(this.defaultComponentFactory(), componentKey, component.getClass(), null));
        this.componentRegistry.putComponent(componentKey, component);
        this.componentRegistry.addOrderedComponent(component);
        this.unmanagedComponents.add(component);
    }

    private ComponentFactory defaultComponentFactory() {
        return this.componentFactory;
    }

    public void addParameterToComponent(Object componentKey, Class parameter, Object arg) throws PicoIntrospectionException {
        ComponentSpecification componentSpec = this.componentRegistry.getComponentSpec(componentKey);
        componentSpec.addConstantParameterBasedOnType(parameter, arg);
    }

    public void registerComponentByClass(Class componentImplementation) throws DuplicateComponentKeyRegistrationException, AssignabilityRegistrationException, NotConcreteRegistrationException, PicoIntrospectionException {
        this.registerComponent((Object)componentImplementation, componentImplementation);
    }

    public void unregisterComponent(Object componentKey) {
        this.componentRegistry.unregisterComponent(componentKey);
    }

    public void instantiateComponents() throws PicoInitializationException, PicoInvocationTargetInitializationException {
        if (this.initialized) {
            throw new IllegalStateException("PicoContainer Started Already");
        }
        this.initializeComponents();
        this.initialized = true;
    }

    private void initializeComponents() throws PicoInitializationException {
        Iterator iterator = this.componentRegistry.getComponentSpecifications().iterator();
        while (iterator.hasNext()) {
            this.componentRegistry.createComponent((ComponentSpecification)iterator.next());
        }
    }

    public Object getComponent(Object componentKey) {
        return this.componentRegistry.getComponentInstance(componentKey);
    }

    public Collection getComponents() {
        return this.componentRegistry.getComponentInstances();
    }

    public Collection getComponentKeys() {
        return this.componentRegistry.getComponentInstanceKeys();
    }

    public final boolean hasComponent(Object componentKey) {
        return this.getComponent(componentKey) != null;
    }

    public static class WithComponentRegistry
    extends DefaultPicoContainer {
        public WithComponentRegistry(ComponentRegistry componentRegistry) {
            super(new DefaultComponentFactory(), componentRegistry);
        }
    }

    public static class WithComponentFactory
    extends DefaultPicoContainer {
        public WithComponentFactory(ComponentFactory componentFactory) {
            super(componentFactory, new DefaultComponentRegistry());
        }
    }

    public static class Default
    extends DefaultPicoContainer {
        public Default() {
            super(new DefaultComponentFactory(), new DefaultComponentRegistry());
        }
    }
}

