/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.extras;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultComponentRegistry;
import org.picocontainer.extras.NullContainer;
import org.picocontainer.internals.ComponentRegistry;

public class CompositePicoContainer
implements PicoContainer,
Serializable {
    private final List containers = new ArrayList();
    private final ComponentRegistry componentRegistry;

    public CompositePicoContainer(ComponentRegistry componentRegistry, PicoContainer[] containers) {
        this.componentRegistry = componentRegistry;
        if (containers == null) {
            throw new NullPointerException("containers can't be null");
        }
        for (int i = 0; i < containers.length; ++i) {
            PicoContainer container = containers[i];
            if (container == null) {
                throw new NullPointerException("PicoContainer at position " + i + " was null");
            }
            this.containers.add(container);
        }
    }

    public Object getComponent(Object componentKey) {
        Object answer = this.componentRegistry.getComponentInstance(componentKey);
        if (answer == null) {
            Iterator iter = this.containers.iterator();
            while (iter.hasNext()) {
                PicoContainer container = (PicoContainer)iter.next();
                if (!container.hasComponent(componentKey)) continue;
                return container.getComponent(componentKey);
            }
        }
        return answer;
    }

    public Collection getComponentKeys() {
        HashSet componentTypes = new HashSet();
        componentTypes.addAll(this.componentRegistry.getComponentInstanceKeys());
        Iterator iter = this.containers.iterator();
        while (iter.hasNext()) {
            PicoContainer container = (PicoContainer)iter.next();
            componentTypes.addAll(container.getComponentKeys());
        }
        return Collections.unmodifiableSet(componentTypes);
    }

    public void instantiateComponents() {
        throw new UnsupportedOperationException();
    }

    public boolean hasComponent(Object componentKey) {
        if (this.componentRegistry.hasComponentInstance(componentKey)) {
            return true;
        }
        Iterator iter = this.containers.iterator();
        while (iter.hasNext()) {
            PicoContainer container = (PicoContainer)iter.next();
            if (!container.hasComponent(componentKey)) continue;
            return true;
        }
        return false;
    }

    public Collection getComponents() {
        HashSet componentTypes = new HashSet();
        componentTypes.addAll(this.componentRegistry.getComponentInstanceKeys());
        Iterator iter = this.containers.iterator();
        while (iter.hasNext()) {
            PicoContainer container = (PicoContainer)iter.next();
            componentTypes.addAll(container.getComponentKeys());
        }
        HashSet<Object> set = new HashSet<Object>();
        Iterator iterator = componentTypes.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            set.add(this.getComponent(key));
        }
        return Collections.unmodifiableSet(set);
    }

    public Object getComponentMulticaster() {
        throw new UnsupportedOperationException();
    }

    public Object getComponentMulticaster(boolean callInInstantiationOrder, boolean callUnmanagedComponents) {
        throw new UnsupportedOperationException();
    }

    protected void addContainer(PicoContainer container) {
        this.containers.add(container);
    }

    protected void removeContainer(PicoContainer container) {
        this.containers.remove(container);
    }

    public static class Default
    extends CompositePicoContainer {
        public Default() {
            super(new DefaultComponentRegistry(), new PicoContainer[]{new NullContainer()});
        }
    }

    public static class WithContainerArray
    extends CompositePicoContainer {
        public WithContainerArray(PicoContainer[] containers) {
            super(new DefaultComponentRegistry(), containers);
        }
    }
}

