/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.extras;

import org.picocontainer.PicoContainer;
import org.picocontainer.lifecycle.Disposable;
import org.picocontainer.lifecycle.LifecyclePicoAdaptor;
import org.picocontainer.lifecycle.Startable;
import org.picocontainer.lifecycle.Stoppable;

public class DefaultLifecyclePicoAdaptor
implements LifecyclePicoAdaptor {
    private Startable startableAggregatedComponent;
    private Stoppable stoppableAggregatedComponent;
    private Disposable disposableAggregatedComponent;
    private boolean started;
    private boolean disposed;
    private final PicoContainer picoContainer;

    public DefaultLifecyclePicoAdaptor(PicoContainer picoContainer) {
        this.picoContainer = picoContainer;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private void initializeIfNotInitialized() {
        if (this.startableAggregatedComponent == null) {
            try {
                this.startableAggregatedComponent = (Startable)this.picoContainer.getComponentMulticaster(true, false);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        if (this.stoppableAggregatedComponent == null) {
            try {
                this.stoppableAggregatedComponent = (Stoppable)this.picoContainer.getComponentMulticaster(false, false);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        if (this.disposableAggregatedComponent == null) {
            try {
                Object o = this.picoContainer.getComponentMulticaster(false, false);
                this.disposableAggregatedComponent = (Disposable)o;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public void start() throws Exception {
        this.checkDisposed();
        this.initializeIfNotInitialized();
        if (this.started) {
            throw new IllegalStateException("Already started.");
        }
        this.started = true;
        if (this.startableAggregatedComponent != null) {
            this.startableAggregatedComponent.start();
        }
    }

    public void stop() throws Exception {
        this.checkDisposed();
        this.initializeIfNotInitialized();
        if (!this.started) {
            throw new IllegalStateException("Already stopped.");
        }
        this.started = false;
        if (this.stoppableAggregatedComponent != null) {
            this.stoppableAggregatedComponent.stop();
        }
    }

    public void dispose() throws Exception {
        this.checkDisposed();
        this.initializeIfNotInitialized();
        this.disposed = true;
        if (this.disposableAggregatedComponent != null) {
            this.disposableAggregatedComponent.dispose();
        }
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Components Disposed Of");
        }
    }
}

