/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.extras;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.DefaultComponentRegistry;
import org.picocontainer.internals.ComponentRegistry;
import org.picocontainer.internals.ComponentSpecification;

public class HierarchicalComponentRegistry
implements ComponentRegistry,
Serializable {
    protected final ComponentRegistry parentRegistry;
    protected final ComponentRegistry childRegistry;

    protected HierarchicalComponentRegistry(ComponentRegistry parentRegistry, ComponentRegistry childRegistry) {
        if (parentRegistry == null) {
            throw new NullPointerException("parentRegistry cannot be null");
        }
        if (childRegistry == null) {
            throw new NullPointerException("childRegistry cannot be null");
        }
        this.parentRegistry = parentRegistry;
        this.childRegistry = childRegistry;
    }

    public void registerComponent(ComponentSpecification compSpec) {
        this.childRegistry.registerComponent(compSpec);
    }

    public void unregisterComponent(Object componentKey) {
        this.childRegistry.unregisterComponent(componentKey);
    }

    public Collection getComponentSpecifications() {
        return this.childRegistry.getComponentSpecifications();
    }

    public List getOrderedComponents() {
        ArrayList types = new ArrayList(this.childRegistry.getOrderedComponents());
        types.addAll(this.parentRegistry.getOrderedComponents());
        return Collections.unmodifiableList(types);
    }

    public void addOrderedComponent(Object component) {
        this.childRegistry.addOrderedComponent(component);
    }

    public void putComponent(Object componentKey, Object component) {
        this.childRegistry.putComponent(componentKey, component);
    }

    public boolean contains(Object componentKey) {
        return this.childRegistry.contains(componentKey);
    }

    public Object getComponentInstance(Object componentKey) {
        Object result = this.childRegistry.getComponentInstance(componentKey);
        if (result == null) {
            result = this.parentRegistry.getComponentInstance(componentKey);
        }
        return result;
    }

    public Set getComponentInstanceKeys() {
        HashSet types = new HashSet(this.childRegistry.getComponentInstanceKeys());
        types.addAll(this.parentRegistry.getComponentInstanceKeys());
        return Collections.unmodifiableSet(types);
    }

    public Set getComponentInstances() {
        HashSet types = new HashSet(this.childRegistry.getComponentInstances());
        types.addAll(this.parentRegistry.getComponentInstances());
        return Collections.unmodifiableSet(types);
    }

    public boolean hasComponentInstance(Object componentKey) {
        return this.childRegistry.hasComponentInstance(componentKey) | this.parentRegistry.hasComponentInstance(componentKey);
    }

    public ComponentSpecification getComponentSpec(Object componentKey) {
        ComponentSpecification result = this.childRegistry.getComponentSpec(componentKey);
        if (result == null) {
            result = this.parentRegistry.getComponentSpec(componentKey);
        }
        return result;
    }

    public Object findImplementingComponent(Class componentType) throws AmbiguousComponentResolutionException {
        Object result = this.childRegistry.findImplementingComponent(componentType);
        if (result == null) {
            result = this.parentRegistry.findImplementingComponent(componentType);
        }
        return result;
    }

    public ComponentSpecification findImplementingComponentSpecification(Class componentType) throws AmbiguousComponentResolutionException {
        ComponentSpecification result = this.childRegistry.findImplementingComponentSpecification(componentType);
        if (result == null) {
            result = this.parentRegistry.findImplementingComponentSpecification(componentType);
        }
        return result;
    }

    public Object createComponent(ComponentSpecification componentSpecification) throws PicoInitializationException {
        if (!this.contains(componentSpecification.getComponentKey())) {
            Object component = componentSpecification.instantiateComponent(this);
            this.addOrderedComponent(component);
            this.putComponent(componentSpecification.getComponentKey(), component);
            return component;
        }
        return this.getComponentInstance(componentSpecification.getComponentKey());
    }

    public static class WithChildRegistry
    extends HierarchicalComponentRegistry {
        public WithChildRegistry(ComponentRegistry parentRegistry, ComponentRegistry childRegistry) {
            super(parentRegistry, childRegistry);
        }
    }

    public static class Default
    extends HierarchicalComponentRegistry {
        public Default(ComponentRegistry parentRegistry) {
            super(parentRegistry, new DefaultComponentRegistry());
        }
    }
}

