/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.extras;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.internals.ComponentFactory;
import org.picocontainer.internals.ComponentSpecification;

public class ImplementationHidingComponentFactory
implements ComponentFactory {
    private final ComponentFactory componentFactory;

    public ImplementationHidingComponentFactory(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public Object createComponent(ComponentSpecification componentSpec, Object[] instanceDependencies) throws PicoInitializationException {
        Object componentInstance = this.componentFactory.createComponent(componentSpec, instanceDependencies);
        if (componentInstance == null) {
            throw new NullPointerException("Unable to create componentInstance for componentSpec" + componentSpec);
        }
        Class[] interfaces = new Class[]{(Class)componentSpec.getComponentKey()};
        return Proxy.newProxyInstance(componentSpec.getComponentImplementation().getClassLoader(), interfaces, (InvocationHandler)new ImplementationHidingProxy(componentInstance));
    }

    public Class[] getDependencies(Class componentImplementation) throws PicoIntrospectionException {
        return this.componentFactory.getDependencies(componentImplementation);
    }

    private class ImplementationHidingProxy
    implements InvocationHandler {
        private Object componentInstance;

        public ImplementationHidingProxy(Object componentInstance) {
            this.componentInstance = componentInstance;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.componentInstance, args);
        }
    }
}

