/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.internals;

import java.io.Serializable;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.defaults.UnsatisfiedDependencyInstantiationException;
import org.picocontainer.internals.ComponentRegistry;
import org.picocontainer.internals.ComponentSpecification;
import org.picocontainer.internals.Parameter;

public class ComponentParameter
implements Parameter,
Serializable {
    private Object componentKey;

    public ComponentParameter() {
    }

    public ComponentParameter(Object componentKey) {
        this.componentKey = componentKey;
    }

    public Object resolve(ComponentRegistry componentRegistry, ComponentSpecification compSpec, Class requestedType) throws PicoInitializationException {
        Object componentInstance;
        ComponentSpecification componentSpecification = null;
        if (this.componentKey != null) {
            componentInstance = componentRegistry.getComponentInstance(this.componentKey);
            if (componentInstance == null) {
                componentSpecification = componentRegistry.getComponentSpec(this.componentKey);
            }
        } else {
            componentInstance = componentRegistry.getComponentInstance(requestedType);
            if (componentInstance == null && (componentInstance = componentRegistry.findImplementingComponent(requestedType)) == null) {
                componentSpecification = componentRegistry.findImplementingComponentSpecification(requestedType);
            }
        }
        if (componentSpecification != null) {
            componentInstance = componentRegistry.createComponent(componentSpecification);
        }
        if (componentInstance == null) {
            throw new UnsatisfiedDependencyInstantiationException(compSpec.getComponentImplementation(), this.componentKey, requestedType);
        }
        return componentInstance;
    }
}

