/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.internals;

import java.io.Serializable;
import java.util.Arrays;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.internals.ComponentFactory;
import org.picocontainer.internals.ComponentParameter;
import org.picocontainer.internals.ComponentRegistry;
import org.picocontainer.internals.ConstantParameter;
import org.picocontainer.internals.Parameter;

public class ComponentSpecification
implements Serializable {
    private final ComponentFactory componentFactory;
    private final Object componentKey;
    private final Class componentImplementation;
    private Parameter[] parameters;
    static /* synthetic */ Class class$java$lang$Integer;

    public ComponentSpecification(ComponentFactory componentFactory, Object componentKey, Class comp, Parameter[] parameters) {
        this.componentFactory = componentFactory;
        this.componentKey = componentKey;
        this.componentImplementation = comp;
        this.parameters = parameters;
    }

    public ComponentSpecification(ComponentFactory componentFactory, Object componentKey, Class comp) throws PicoIntrospectionException {
        this.componentFactory = componentFactory;
        this.componentKey = componentKey;
        this.componentImplementation = comp;
        this.parameters = new Parameter[componentFactory.getDependencies(comp).length];
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = this.createDefaultParameter();
        }
    }

    protected Parameter createDefaultParameter() {
        return new ComponentParameter();
    }

    public Object getComponentKey() {
        return this.componentKey;
    }

    public Class getComponentImplementation() {
        return this.componentImplementation;
    }

    public Object instantiateComponent(ComponentRegistry componentRegistry) throws PicoInitializationException {
        Class[] dependencyTypes = this.componentFactory.getDependencies(this.componentImplementation);
        Object[] dependencies = new Object[dependencyTypes.length];
        for (int i = 0; i < dependencies.length; ++i) {
            dependencies[i] = this.parameters[i].resolve(componentRegistry, this, dependencyTypes[i]);
        }
        return this.componentFactory.createComponent(this, dependencies);
    }

    public static boolean isAssignableFrom(Class actual, Class requested) {
        if (actual == Integer.TYPE || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = ComponentSpecification.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return requested == Integer.TYPE || requested == (class$java$lang$Integer == null ? (class$java$lang$Integer = ComponentSpecification.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
        return actual.isAssignableFrom(requested);
    }

    public void addConstantParameterBasedOnType(Class parameter, Object arg) throws PicoIntrospectionException {
        Class[] dependencies = this.componentFactory.getDependencies(this.componentImplementation);
        for (int i = 0; i < dependencies.length; ++i) {
            if (!ComponentSpecification.isAssignableFrom(dependencies[i], parameter) || this.parameters[i] instanceof ConstantParameter) continue;
            this.parameters[i] = new ConstantParameter(arg);
            return;
        }
        throw new RuntimeException("No such parameter " + parameter + " in " + Arrays.asList(dependencies));
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ComponentSpecification other = (ComponentSpecification)object;
        return this.getComponentKey().equals(other.getComponentKey()) && this.getComponentImplementation().equals(other.getComponentImplementation()) && ((Object)Arrays.asList(this.getParameters())).equals(Arrays.asList(other.getParameters()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

