/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentMulticasterFactory;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public abstract class AbstractPicoContainer
implements MutablePicoContainer,
Serializable {
    private final List unmanagedComponents = new ArrayList();
    private final List orderedComponents = new ArrayList();
    private final ComponentAdapterFactory componentAdapterFactory;

    public abstract Collection getComponentKeys();

    public abstract List getComponentAdapters();

    public abstract void registerComponent(ComponentAdapter var1) throws PicoRegistrationException;

    public abstract ComponentAdapter findComponentAdapter(Object var1) throws AmbiguousComponentResolutionException;

    protected AbstractPicoContainer(ComponentAdapterFactory componentAdapterFactory) {
        this.componentAdapterFactory = componentAdapterFactory;
    }

    public void registerComponentInstance(Object component) throws PicoRegistrationException {
        this.registerComponentInstance(component.getClass(), component);
    }

    public void registerComponentInstance(Object componentKey, Object componentInstance) throws PicoRegistrationException {
        InstanceComponentAdapter componentAdapter = new InstanceComponentAdapter(componentKey, componentInstance);
        this.registerComponent(componentAdapter);
        this.addOrderedComponentInstance(componentInstance);
        this.unmanagedComponents.add(componentInstance);
    }

    public void registerComponentImplementation(Class componentImplementation) throws PicoRegistrationException {
        this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public Object getComponentMulticaster(boolean callInInstantiationOrder, boolean callUnmanagedComponents) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        DefaultComponentMulticasterFactory componentMulticasterFactory = new DefaultComponentMulticasterFactory();
        this.getComponentInstances();
        List componentsToMulticast = this.getOrderedComponents();
        if (!callUnmanagedComponents) {
            Iterator iterator = this.unmanagedComponents.iterator();
            while (iterator.hasNext()) {
                componentsToMulticast.remove(iterator.next());
            }
        }
        return componentMulticasterFactory.createComponentMulticaster(this.getClass().getClassLoader(), componentsToMulticast, callInInstantiationOrder);
    }

    public Object getComponentMulticaster() throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        return this.getComponentMulticaster(true, false);
    }

    public void registerComponentImplementation(Object componentKey, Class componentImplementation) throws PicoRegistrationException {
        this.registerComponentImplementation(componentKey, componentImplementation, null);
    }

    public void registerComponentImplementation(Object componentKey, Class componentImplementation, Parameter[] parameters) throws PicoRegistrationException {
        ComponentAdapter componentAdapter = this.componentAdapterFactory.createComponentAdapter(componentKey, componentImplementation, parameters);
        this.registerComponent(componentAdapter);
    }

    public List getOrderedComponents() {
        return new ArrayList(this.orderedComponents);
    }

    public void addOrderedComponentInstance(Object componentInstance) {
        this.orderedComponents.add(componentInstance);
    }

    public Collection getComponentInstances() throws PicoException {
        ArrayList<Object> componentInstances = new ArrayList<Object>(this.getComponentKeys().size());
        Iterator iterator = this.getComponentKeys().iterator();
        while (iterator.hasNext()) {
            Object componentInstance = this.getComponentInstance(iterator.next());
            componentInstances.add(componentInstance);
        }
        return Collections.unmodifiableCollection(componentInstances);
    }

    public Object getComponentInstance(Object componentKey) throws PicoException {
        ComponentAdapter componentAdapter = this.findComponentAdapter(componentKey);
        if (componentAdapter != null) {
            return componentAdapter.getComponentInstance(this);
        }
        return null;
    }

    public Object findComponentInstance(Class componentType) throws PicoException {
        ArrayList foundKeys = new ArrayList();
        Object result = null;
        Iterator iterator = this.getComponentKeys().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object componentInstance = this.getComponentInstance(key);
            if (!componentType.isInstance(componentInstance)) continue;
            result = componentInstance;
            foundKeys.add(key);
        }
        if (foundKeys.size() == 0) {
            return null;
        }
        if (foundKeys.size() > 1) {
            throw new AmbiguousComponentResolutionException(componentType, foundKeys.toArray());
        }
        return result;
    }

    public boolean hasComponent(Object componentKey) {
        return this.getComponentKeys().contains(componentKey);
    }

    public ComponentAdapter findImplementingComponentAdapter(Class componentType) throws PicoException {
        ArrayList<ComponentAdapter> found = new ArrayList<ComponentAdapter>();
        Iterator iterator = this.getComponentAdapters().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            found.add(componentAdapter);
        }
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        if (found.size() == 0) {
            return null;
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            ComponentAdapter componentAdapter = (ComponentAdapter)found.get(i);
            foundClasses[i] = componentAdapter.getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public abstract /* synthetic */ void unregisterComponent(Object var1);
}

