/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AbstractComponentAdapter;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.NoSatisfiableConstructorsException;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;

public class DefaultComponentAdapter
extends AbstractComponentAdapter {
    private Parameter[] parameters;
    private Object componentInstance;
    static /* synthetic */ Class class$java$lang$Integer;

    public DefaultComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation);
        this.parameters = parameters;
    }

    public DefaultComponentAdapter(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentImplementation, null);
    }

    public Class[] getDependencies(MutablePicoContainer componentRegistry) throws PicoIntrospectionException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Constructor constructor = this.getConstructor(componentRegistry);
        return constructor.getParameterTypes();
    }

    private Constructor getConstructor(MutablePicoContainer componentRegistry) throws PicoIntrospectionException, NoSatisfiableConstructorsException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        List<Constructor<?>> allConstructors = Arrays.asList(this.getComponentImplementation().getConstructors());
        List satisfiableConstructors = this.getSatisfiableConstructors(allConstructors, componentRegistry);
        Constructor biggestConstructor = null;
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        for (int i = 0; i < satisfiableConstructors.size(); ++i) {
            Constructor currentConstructor = (Constructor)satisfiableConstructors.get(i);
            if (biggestConstructor == null) {
                biggestConstructor = currentConstructor;
                continue;
            }
            if (biggestConstructor.getParameterTypes().length < currentConstructor.getParameterTypes().length) {
                conflicts.clear();
                biggestConstructor = currentConstructor;
                continue;
            }
            if (biggestConstructor.getParameterTypes().length != currentConstructor.getParameterTypes().length) continue;
            conflicts.add(biggestConstructor);
            conflicts.add(currentConstructor);
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        if (biggestConstructor == null) {
            throw new NoSatisfiableConstructorsException(this.getComponentImplementation());
        }
        return biggestConstructor;
    }

    private List getSatisfiableConstructors(List constructors, MutablePicoContainer componentRegistry) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        ArrayList<Constructor> result = new ArrayList<Constructor>();
        Iterator iterator = constructors.iterator();
        while (iterator.hasNext()) {
            Constructor constructor = (Constructor)iterator.next();
            Class[] parameterTypes = constructor.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            boolean failedDependency = false;
            for (int i = 0; i < currentParameters.length; ++i) {
                ComponentAdapter adapter = currentParameters[i].resolveAdapter(componentRegistry);
                if (adapter == null) {
                    failedDependency = true;
                    break;
                }
                if (adapter.equals(this)) {
                    failedDependency = true;
                    break;
                }
                if (!this.getComponentKey().equals(adapter.getComponentKey())) continue;
                failedDependency = true;
                break;
            }
            if (failedDependency) continue;
            result.add(constructor);
        }
        return result;
    }

    public Object getComponentInstance(MutablePicoContainer mutablePicoContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.componentInstance == null) {
            Class[] dependencyTypes = this.getDependencies(mutablePicoContainer);
            ComponentAdapter[] adapterDependencies = new ComponentAdapter[dependencyTypes.length];
            Parameter[] componentParameters = this.getParameters(mutablePicoContainer);
            for (int i = 0; i < adapterDependencies.length; ++i) {
                adapterDependencies[i] = componentParameters[i].resolveAdapter(mutablePicoContainer);
            }
            this.componentInstance = this.createComponent(adapterDependencies, mutablePicoContainer);
            mutablePicoContainer.addOrderedComponentInstance(this.componentInstance);
        }
        return this.componentInstance;
    }

    private Object createComponent(ComponentAdapter[] adapterDependencies, MutablePicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        try {
            Constructor constructor = this.getConstructor(picoContainer);
            Object[] parameters = new Object[adapterDependencies.length];
            for (int i = 0; i < adapterDependencies.length; ++i) {
                ComponentAdapter adapterDependency = adapterDependencies[i];
                parameters[i] = adapterDependency.getComponentInstance(picoContainer);
            }
            return constructor.newInstance(parameters);
        }
        catch (InvocationTargetException e) {
            throw new PicoInvocationTargetInitializationException(e.getCause());
        }
        catch (InstantiationException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
    }

    public static boolean isAssignableFrom(Class actual, Class requested) {
        if (actual == Integer.TYPE || actual == (class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultComponentAdapter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return requested == Integer.TYPE || requested == (class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultComponentAdapter.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
        return actual.isAssignableFrom(requested);
    }

    private Parameter[] getParameters(MutablePicoContainer componentRegistry) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.parameters == null) {
            return this.createDefaultParameters(this.getDependencies(componentRegistry));
        }
        return this.parameters;
    }

    public boolean equals(Object object) {
        ComponentAdapter other = (ComponentAdapter)object;
        return this.getComponentKey().equals(other.getComponentKey()) && this.getComponentImplementation().equals(other.getComponentImplementation());
    }

    private Parameter[] createDefaultParameters(Class[] parameters) {
        Parameter[] componentParameters = new ComponentParameter[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            componentParameters[i] = new ComponentParameter(parameters[i]);
        }
        return componentParameters;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

