/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.defaults.AbstractPicoContainer;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;

public class DefaultPicoContainer
extends AbstractPicoContainer {
    private final Map componentKeyToAdapterMap = new HashMap();

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory) {
        super(componentAdapterFactory);
    }

    public DefaultPicoContainer() {
        this(new DefaultComponentAdapterFactory());
    }

    public Collection getComponentKeys() {
        return Collections.unmodifiableCollection(this.componentKeyToAdapterMap.keySet());
    }

    public List getComponentAdapters() {
        return new ArrayList(this.componentKeyToAdapterMap.values());
    }

    public ComponentAdapter findComponentAdapter(Object componentKey) throws AmbiguousComponentResolutionException {
        ComponentAdapter result = (ComponentAdapter)this.componentKeyToAdapterMap.get(componentKey);
        if (result == null && componentKey instanceof Class) {
            Class classKey = (Class)componentKey;
            result = this.findImplementingComponentAdapter(classKey);
        }
        return result;
    }

    public void registerComponent(ComponentAdapter componentAdapter) throws DuplicateComponentKeyRegistrationException {
        if (this.getComponentKeys().contains(componentAdapter.getComponentKey())) {
            throw new DuplicateComponentKeyRegistrationException(componentAdapter.getComponentKey());
        }
        this.componentKeyToAdapterMap.put(componentAdapter.getComponentKey(), componentAdapter);
    }

    public void unregisterComponent(Object componentKey) {
        this.componentKeyToAdapterMap.remove(componentKey);
    }
}

