/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.extras;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.extras.DecoratingComponentAdapter;
import org.picocontainer.extras.DecoratingComponentAdapterFactory;

public class BeanPropertyComponentAdapterFactory
extends DecoratingComponentAdapterFactory {
    private Map componentProperties = new HashMap();

    public BeanPropertyComponentAdapterFactory(ComponentAdapterFactory delegate) {
        super(delegate);
    }

    public ComponentAdapter createComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        ComponentAdapter decoratedAdapter = super.createComponentAdapter(componentKey, componentImplementation, parameters);
        Map propertyMap = (Map)this.componentProperties.get(componentKey);
        Adapter propertyAdapter = new Adapter(decoratedAdapter, propertyMap);
        return propertyAdapter;
    }

    public void setProperties(Object componentKey, Map properies) {
        this.componentProperties.put(componentKey, properies);
    }

    private class Adapter
    extends DecoratingComponentAdapter {
        private final Map propertyValues;
        private PropertyDescriptor[] propertyDescriptors;
        private Map propertyDescriptorMap = new HashMap();
        private Object componentInstance = null;

        public Adapter(ComponentAdapter delegate, Map propertyValues) throws PicoBeanInfoInitializationException {
            super(delegate);
            this.propertyValues = propertyValues;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(delegate.getComponentImplementation());
                this.propertyDescriptors = beanInfo.getPropertyDescriptors();
                for (int i = 0; i < this.propertyDescriptors.length; ++i) {
                    PropertyDescriptor propertyDescriptor = this.propertyDescriptors[i];
                    this.propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
                }
            }
            catch (IntrospectionException e) {
                throw new PicoBeanInfoInitializationException("Couldn't load BeanInfo for" + delegate.getComponentImplementation().getName(), e);
            }
        }

        public Object getComponentInstance(MutablePicoContainer picoContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
            if (this.componentInstance == null) {
                this.componentInstance = super.getComponentInstance(picoContainer);
                Set propertyNames = this.propertyValues.keySet();
                Iterator iterator = propertyNames.iterator();
                while (iterator.hasNext()) {
                    String propertyName = (String)iterator.next();
                    Object propertyValue = this.propertyValues.get(propertyName);
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.propertyDescriptorMap.get(propertyName);
                    Method setter = propertyDescriptor.getWriteMethod();
                    try {
                        setter.invoke(this.componentInstance, propertyValue);
                    }
                    catch (Exception e) {
                        throw new PicoInitializationException(this, propertyName, propertyValue, e){
                            private final /* synthetic */ String val$propertyName;
                            private final /* synthetic */ Object val$propertyValue;
                            private final /* synthetic */ Exception val$e;
                            private final /* synthetic */ Adapter this$1;
                            {
                                this.this$1 = this$1;
                                this.val$propertyName = val$propertyName;
                                this.val$propertyValue = val$propertyValue;
                                this.val$e = val$e;
                            }

                            public String getMessage() {
                                return "Failed to set property " + this.val$propertyName + " to " + this.val$propertyValue + ". " + this.val$e.getMessage();
                            }
                        };
                    }
                }
            }
            return this.componentInstance;
        }
    }

    public static class NoSuchPropertyException
    extends PicoInitializationException {
        public NoSuchPropertyException(String message) {
            super(message);
        }
    }

    public static class PicoBeanInfoInitializationException
    extends PicoIntrospectionException {
        protected PicoBeanInfoInitializationException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

