/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.extras;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.defaults.AbstractPicoContainer;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;

public class DelegatingPicoContainer
extends DefaultPicoContainer {
    private final List delegates;

    public DelegatingPicoContainer(ComponentAdapterFactory componentAdapterFactory, MutablePicoContainer[] delegates) {
        super(componentAdapterFactory);
        this.delegates = Arrays.asList(delegates);
    }

    public DelegatingPicoContainer(ComponentAdapterFactory componentAdapterFactory, MutablePicoContainer delegate) {
        this(componentAdapterFactory, new MutablePicoContainer[]{delegate});
    }

    public DelegatingPicoContainer(MutablePicoContainer[] delegates) {
        this((ComponentAdapterFactory)new DefaultComponentAdapterFactory(), delegates);
    }

    public DelegatingPicoContainer(MutablePicoContainer delegate) {
        this((ComponentAdapterFactory)new DefaultComponentAdapterFactory(), delegate);
    }

    public Collection getComponentKeys() {
        HashSet result = new HashSet();
        result.addAll(super.getComponentKeys());
        Iterator iterator = this.delegates.iterator();
        while (iterator.hasNext()) {
            AbstractPicoContainer delegate = (AbstractPicoContainer)iterator.next();
            result.addAll(delegate.getComponentKeys());
        }
        return result;
    }

    public ComponentAdapter findComponentAdapter(Object componentKey) throws AmbiguousComponentResolutionException {
        ComponentAdapter result = super.findComponentAdapter(componentKey);
        if (result != null) {
            return result;
        }
        Iterator iterator = this.delegates.iterator();
        while (iterator.hasNext()) {
            AbstractPicoContainer delegate = (AbstractPicoContainer)iterator.next();
            ComponentAdapter componentAdapter = delegate.findComponentAdapter(componentKey);
            if (componentAdapter == null) continue;
            return componentAdapter;
        }
        return null;
    }
}

