/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public abstract class AbstractComponentAdapter
implements ComponentAdapter,
Serializable {
    private final Object componentKey;
    private final Class componentImplementation;

    protected AbstractComponentAdapter(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (componentImplementation == null) {
            throw new NullPointerException("componentImplementation");
        }
        this.checkTypeCompatibility(componentKey, componentImplementation);
        this.checkConcrete(componentImplementation);
        this.componentKey = componentKey;
        this.componentImplementation = componentImplementation;
    }

    public Object getComponentKey() {
        if (this.componentKey == null) {
            throw new NullPointerException("componentKey");
        }
        return this.componentKey;
    }

    public Class getComponentImplementation() {
        return this.componentImplementation;
    }

    private void checkTypeCompatibility(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException {
        Class componentType;
        if (componentKey instanceof Class && !(componentType = (Class)componentKey).isAssignableFrom(componentImplementation)) {
            throw new AssignabilityRegistrationException(componentType, componentImplementation);
        }
    }

    private void checkConcrete(Class componentImplementation) throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (componentImplementation.getModifiers() & 0x400) == 1024;
        if (componentImplementation.isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(componentImplementation);
        }
    }

    public abstract /* synthetic */ Object getComponentInstance(MutablePicoContainer var1) throws PicoInitializationException, PicoIntrospectionException;
}

