/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class BeanComponentAdapter
extends InstantiatingComponentAdapter {
    public BeanComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) {
        super(componentKey, componentImplementation, parameters);
    }

    protected Class[] getMostSatisfiableDependencyTypes(PicoContainer dependencyContainer) throws PicoIntrospectionException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Method[] setters = this.getSetters();
        Class[] dependencies = new Class[setters.length];
        for (int i = 0; i < setters.length; ++i) {
            dependencies[i] = setters[i].getParameterTypes()[0];
        }
        return dependencies;
    }

    protected Object instantiateComponent(ComponentAdapter[] adapterDependencies, PicoContainer dependencyContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object result = super.instantiateComponent(adapterDependencies, dependencyContainer);
        this.setDependencies(result, adapterDependencies);
        return result;
    }

    protected Constructor getGreediestSatisifableConstructor(PicoContainer dependencyContainer) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        try {
            return this.getComponentImplementation().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new UnsatisfiableDependenciesException(this.getComponentImplementation(), Collections.EMPTY_SET);
        }
        catch (SecurityException e) {
            throw new UnsatisfiableDependenciesException(this.getComponentImplementation(), Collections.EMPTY_SET);
        }
    }

    protected Object[] getConstructorArguments(ComponentAdapter[] adapterDependencies) {
        return null;
    }

    private void setDependencies(Object componentInstance, ComponentAdapter[] adapterDependencies) {
        Method[] setters = this.getSetters();
        for (int i = 0; i < setters.length; ++i) {
            Method setter = setters[i];
            ComponentAdapter adapterDependency = adapterDependencies[i];
            Object dependency = adapterDependency.getComponentInstance();
            try {
                setter.invoke(componentInstance, dependency);
                continue;
            }
            catch (Exception e) {
                throw new PicoIntrospectionException(e);
            }
        }
    }

    private Method[] getSetters() {
        ArrayList<Method> setters = new ArrayList<Method>();
        Method[] methods = this.getComponentImplementation().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            boolean isBeanStyle;
            Method method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            boolean hasOneParameter = parameterTypes.length == 1;
            boolean bl = isBeanStyle = method.getName().length() >= 4 && method.getName().startsWith("set") && Character.isUpperCase(method.getName().charAt(3));
            if (!hasOneParameter || !isBeanStyle) continue;
            setters.add(method);
        }
        return setters.toArray(new Method[setters.size()]);
    }
}

