/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ConstructorComponentAdapter
extends InstantiatingComponentAdapter {
    public ConstructorComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters);
    }

    public ConstructorComponentAdapter(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentImplementation, null);
    }

    protected Class[] getMostSatisfiableDependencyTypes(PicoContainer dependencyContainer) throws PicoIntrospectionException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Constructor constructor = this.getGreediestSatisifableConstructor(dependencyContainer);
        return constructor.getParameterTypes();
    }

    protected Constructor getGreediestSatisifableConstructor(PicoContainer dependencyContainer) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        List<Constructor<?>> allConstructors = Arrays.asList(this.getComponentImplementation().getConstructors());
        List satisfiableConstructors = this.getAllSatisfiableConstructors(allConstructors, dependencyContainer);
        Constructor greediestConstructor = null;
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        for (int i = 0; i < satisfiableConstructors.size(); ++i) {
            Constructor currentConstructor = (Constructor)satisfiableConstructors.get(i);
            if (greediestConstructor == null) {
                greediestConstructor = currentConstructor;
                continue;
            }
            if (greediestConstructor.getParameterTypes().length < currentConstructor.getParameterTypes().length) {
                conflicts.clear();
                greediestConstructor = currentConstructor;
                continue;
            }
            if (greediestConstructor.getParameterTypes().length != currentConstructor.getParameterTypes().length) continue;
            conflicts.add(greediestConstructor);
            conflicts.add(currentConstructor);
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        return greediestConstructor;
    }

    private List getAllSatisfiableConstructors(List constructors, PicoContainer picoContainer) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        ArrayList<Constructor> satisfiableConstructors = new ArrayList<Constructor>();
        HashSet<Class> unusableAdapters = new HashSet<Class>();
        Iterator iterator = constructors.iterator();
        while (iterator.hasNext()) {
            boolean failedDependency = false;
            Constructor constructor = (Constructor)iterator.next();
            Class[] parameterTypes = constructor.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : InstantiatingComponentAdapter.createDefaultParameters(parameterTypes, picoContainer);
            for (int i = 0; i < currentParameters.length; ++i) {
                ComponentAdapter adapter = currentParameters[i].resolveAdapter(picoContainer);
                if (adapter == null) {
                    failedDependency = true;
                    unusableAdapters.add(parameterTypes[i]);
                    continue;
                }
                if (adapter.equals(this)) {
                    failedDependency = true;
                    unusableAdapters.add(parameterTypes[i]);
                }
                if (!this.getComponentKey().equals(adapter.getComponentKey())) continue;
                failedDependency = true;
                unusableAdapters.add(parameterTypes[i]);
            }
            if (failedDependency) continue;
            satisfiableConstructors.add(constructor);
        }
        if (satisfiableConstructors.isEmpty()) {
            throw new UnsatisfiableDependenciesException(this.getComponentImplementation(), unusableAdapters);
        }
        return satisfiableConstructors;
    }

    protected Object[] getConstructorArguments(ComponentAdapter[] adapterDependencies) {
        Object[] result = new Object[adapterDependencies.length];
        for (int i = 0; i < adapterDependencies.length; ++i) {
            ComponentAdapter adapterDependency = adapterDependencies[i];
            result[i] = adapterDependency.getComponentInstance();
        }
        return result;
    }
}

