/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.LifecycleAdapter;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class DefaultPicoContainer
implements MutablePicoContainer,
Serializable {
    private final LifecycleAdapter lifecycleAdapter = new LifecycleAdapter(this);
    private final Map componentKeyToAdapterCache = new HashMap();
    private final ComponentAdapterFactory componentAdapterFactory;
    private PicoContainer parent;
    private final List componentAdapters = new ArrayList();
    private final List orderedComponentAdapters = new ArrayList();

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory, PicoContainer parent) {
        this.componentAdapterFactory = componentAdapterFactory;
        this.setParent(parent);
    }

    public DefaultPicoContainer(PicoContainer parent) {
        this(new DefaultComponentAdapterFactory(), parent);
    }

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory) {
        this(componentAdapterFactory, null);
    }

    public DefaultPicoContainer() {
        this(new DefaultComponentAdapterFactory(), null);
    }

    public final Collection getComponentKeys() {
        return this.createComponentAdapterMap(this).keySet();
    }

    private Map createComponentAdapterMap(PicoContainer container) {
        Collection componentAdapters = container.getComponentAdapters();
        HashMap<Object, ComponentAdapter> result = new HashMap<Object, ComponentAdapter>(componentAdapters.size());
        Iterator iterator = componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            result.put(componentAdapter.getComponentKey(), componentAdapter);
        }
        return result;
    }

    private Map getComponentAdapterMap() {
        Map result = this.parent != null ? this.createComponentAdapterMap(this.parent) : new HashMap();
        result.putAll(this.componentKeyToAdapterCache);
        return result;
    }

    public Collection getComponentAdapters() {
        return Collections.unmodifiableList(this.componentAdapters);
    }

    public final ComponentAdapter getComponentAdapter(Object componentKey) throws AmbiguousComponentResolutionException {
        return (ComponentAdapter)this.getComponentAdapterMap().get(componentKey);
    }

    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        ArrayList<ComponentAdapter> found = new ArrayList<ComponentAdapter>();
        Iterator iterator = this.getComponentAdapters().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            found.add(componentAdapter);
        }
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        if (found.size() == 0) {
            if (this.parent != null) {
                return this.parent.getComponentAdapterOfType(componentType);
            }
            return null;
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            ComponentAdapter componentAdapter = (ComponentAdapter)found.get(i);
            foundClasses[i] = componentAdapter.getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public void registerComponent(ComponentAdapter componentAdapter) throws DuplicateComponentKeyRegistrationException {
        componentAdapter.setContainer(this);
        this.componentAdapters.add(componentAdapter);
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.containsKey(componentKey)) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
    }

    public ComponentAdapter unregisterComponent(Object componentKey) {
        ComponentAdapter adapter = (ComponentAdapter)this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        this.orderedComponentAdapters.remove(adapter);
        return adapter;
    }

    public ComponentAdapter registerComponentInstance(Object component) throws PicoRegistrationException {
        return this.registerComponentInstance(component.getClass(), component);
    }

    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) throws PicoRegistrationException {
        InstanceComponentAdapter componentAdapter = new InstanceComponentAdapter(componentKey, componentInstance);
        this.registerComponent(componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter registerComponentImplementation(Class componentImplementation) throws PicoRegistrationException {
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation) throws PicoRegistrationException {
        return this.registerComponentImplementation(componentKey, componentImplementation, null);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, Parameter[] parameters) throws PicoRegistrationException {
        ComponentAdapter componentAdapter = this.componentAdapterFactory.createComponentAdapter(componentKey, componentImplementation, parameters);
        this.registerComponent(componentAdapter);
        return componentAdapter;
    }

    public void addOrderedComponentAdapter(ComponentAdapter componentAdapter) {
        if (!this.orderedComponentAdapters.contains(componentAdapter)) {
            this.orderedComponentAdapters.add(componentAdapter);
        }
    }

    public List getComponentInstances() throws PicoException {
        HashMap<ComponentAdapter, Object> adapterToInstanceMap = new HashMap<ComponentAdapter, Object>();
        Iterator iterator = this.componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            Object componentInstance = componentAdapter.getComponentInstance();
            adapterToInstanceMap.put(componentAdapter, componentInstance);
            this.addOrderedComponentAdapter(componentAdapter);
        }
        ArrayList result = new ArrayList();
        Iterator iterator2 = this.orderedComponentAdapters.iterator();
        while (iterator2.hasNext()) {
            Object componentAdapter = iterator2.next();
            Object componentInstance = adapterToInstanceMap.get(componentAdapter);
            if (componentInstance == null) continue;
            result.add(componentInstance);
        }
        return Collections.unmodifiableList(result);
    }

    public Object getComponentInstance(Object componentKey) throws PicoException {
        ComponentAdapter componentAdapter = this.getComponentAdapter(componentKey);
        if (componentAdapter != null) {
            return componentAdapter.getComponentInstance();
        }
        return null;
    }

    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : componentAdapter.getComponentInstance();
    }

    public boolean hasComponent(Object componentKey) {
        return this.getComponentKeys().contains(componentKey);
    }

    public PicoContainer getParent() {
        return this.parent;
    }

    public void setParent(PicoContainer parent) {
        this.parent = parent;
    }

    public void verify() throws PicoVerificationException {
        ArrayList<UnsatisfiableDependenciesException> nestedVerificationExceptions = new ArrayList<UnsatisfiableDependenciesException>();
        Iterator iterator = this.getComponentAdapters().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            try {
                componentAdapter.verify();
            }
            catch (UnsatisfiableDependenciesException e) {
                nestedVerificationExceptions.add(e);
            }
        }
        if (!nestedVerificationExceptions.isEmpty()) {
            throw new PicoVerificationException(nestedVerificationExceptions);
        }
    }

    public void start() {
        this.lifecycleAdapter.start();
    }

    public void stop() {
        this.lifecycleAdapter.stop();
    }

    public void dispose() {
        this.lifecycleAdapter.dispose();
    }

    public boolean isStarted() {
        return this.lifecycleAdapter.isStarted();
    }

    public boolean isStopped() {
        return this.lifecycleAdapter.isStopped();
    }

    public boolean isDisposed() {
        return this.lifecycleAdapter.isDisposed();
    }
}

