/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AbstractComponentAdapter;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.ConstantParameter;
import org.picocontainer.defaults.CyclicDependencyException;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public abstract class InstantiatingComponentAdapter
extends AbstractComponentAdapter {
    private boolean instantiating;
    private boolean verifying;
    protected Parameter[] parameters;
    static /* synthetic */ Class class$org$picocontainer$PicoContainer;

    public InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation);
        this.parameters = parameters;
    }

    public Object getComponentInstance() throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        ComponentAdapter[] dependencyAdapters = this.getMostSatisifableDependencyAdapters(this.getContainer());
        Object instance = this.instantiateComponent(dependencyAdapters, this.getContainer());
        for (int i = 0; i < dependencyAdapters.length; ++i) {
            ComponentAdapter dependencyAdapter = dependencyAdapters[i];
            this.getContainer().addOrderedComponentAdapter(dependencyAdapter);
        }
        return instance;
    }

    private Parameter[] getParameters(PicoContainer picoContainer) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.parameters == null || this.parameters.length == 0) {
            return InstantiatingComponentAdapter.createDefaultParameters(this.getMostSatisfiableDependencyTypes(picoContainer), picoContainer);
        }
        return this.parameters;
    }

    protected static Parameter[] createDefaultParameters(Class[] parameters, PicoContainer picoContainer) {
        Parameter[] componentParameters = new Parameter[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            componentParameters[i] = (class$org$picocontainer$PicoContainer == null ? InstantiatingComponentAdapter.class$("org.picocontainer.PicoContainer") : class$org$picocontainer$PicoContainer).isAssignableFrom(parameters[i]) ? new ConstantParameter(picoContainer) : new ComponentParameter(parameters[i]);
        }
        return componentParameters;
    }

    private ComponentAdapter[] getMostSatisifableDependencyAdapters(PicoContainer dependencyContainer) {
        final Class[] mostSatisfiableDependencyTypes = this.getMostSatisfiableDependencyTypes(dependencyContainer);
        final ComponentAdapter[] mostSatisfiableDependencyAdapters = new ComponentAdapter[mostSatisfiableDependencyTypes.length];
        final Parameter[] componentParameters = this.getParameters(dependencyContainer);
        if (componentParameters.length != mostSatisfiableDependencyAdapters.length) {
            throw new PicoInitializationException(){

                public String getMessage() {
                    return "The number of specified parameters (" + componentParameters.length + ") doesn't match the number of arguments in the greediest satisfiable constructor (" + mostSatisfiableDependencyAdapters.length + "). When parameters are explicitly specified, specify them in the correct order, and one for each constructor argument." + "The greediest satisfiable constructor takes the following arguments: " + Arrays.asList(mostSatisfiableDependencyTypes).toString();
                }
            };
        }
        for (int i = 0; i < mostSatisfiableDependencyAdapters.length; ++i) {
            mostSatisfiableDependencyAdapters[i] = componentParameters[i].resolveAdapter(dependencyContainer);
        }
        return mostSatisfiableDependencyAdapters;
    }

    protected Object instantiateComponent(ComponentAdapter[] adapterDependencies, PicoContainer dependencyContainer) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        try {
            Constructor constructor = this.getGreediestSatisifableConstructor(dependencyContainer);
            if (this.instantiating) {
                throw new CyclicDependencyException(constructor.getParameterTypes());
            }
            this.instantiating = true;
            Object[] parameters = this.getConstructorArguments(adapterDependencies);
            Object t = constructor.newInstance(parameters);
            return t;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new PicoInvocationTargetInitializationException(e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInvocationTargetInitializationException(e);
        }
        finally {
            this.instantiating = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() throws UnsatisfiableDependenciesException {
        try {
            ComponentAdapter[] adapterDependencies = this.getMostSatisifableDependencyAdapters(this.getContainer());
            if (this.verifying) {
                throw new CyclicDependencyException(this.getMostSatisfiableDependencyTypes(this.getContainer()));
            }
            this.verifying = true;
            for (int i = 0; i < adapterDependencies.length; ++i) {
                ComponentAdapter adapterDependency = adapterDependencies[i];
                adapterDependency.verify();
            }
        }
        finally {
            this.verifying = false;
        }
    }

    protected abstract Class[] getMostSatisfiableDependencyTypes(PicoContainer var1) throws PicoIntrospectionException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException;

    protected abstract Constructor getGreediestSatisifableConstructor(PicoContainer var1) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException;

    protected abstract Object[] getConstructorArguments(ComponentAdapter[] var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

