/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentMulticasterAdapter;
import org.picocontainer.defaults.DefaultComponentMulticasterAdapter;
import org.picocontainer.lifecycle.Disposable;
import org.picocontainer.lifecycle.Lifecycle;
import org.picocontainer.lifecycle.Startable;
import org.picocontainer.lifecycle.Stoppable;

class LifecycleAdapter
implements Lifecycle,
Serializable {
    private boolean started;
    private boolean disposed;
    private final PicoContainer picoContainer;
    private final ComponentMulticasterAdapter componentMulticasterAdapter;

    private LifecycleAdapter(PicoContainer picoContainer, ComponentMulticasterAdapter componentMulticasterAdapter) {
        this.picoContainer = picoContainer;
        this.componentMulticasterAdapter = componentMulticasterAdapter;
    }

    public LifecycleAdapter(PicoContainer picoContainer) {
        this(picoContainer, new DefaultComponentMulticasterAdapter());
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void start() {
        this.checkDisposed();
        if (this.started) {
            throw new IllegalStateException("Already started.");
        }
        try {
            Startable startable = (Startable)this.componentMulticasterAdapter.getComponentMulticaster(this.picoContainer, true);
            startable.start();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.started = true;
    }

    public void stop() {
        this.checkDisposed();
        if (!this.started) {
            throw new IllegalStateException("Already stopped (or maybe never started).");
        }
        try {
            ((Stoppable)this.componentMulticasterAdapter.getComponentMulticaster(this.picoContainer, false)).stop();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.started = false;
    }

    public void dispose() {
        this.checkDisposed();
        try {
            ((Disposable)this.componentMulticasterAdapter.getComponentMulticaster(this.picoContainer, false)).dispose();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.disposed = true;
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Components already disposed of");
        }
    }
}

