/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.util.Set;
import org.picocontainer.PicoIntrospectionException;

public class UnsatisfiableDependenciesException
extends PicoIntrospectionException {
    private final Class componentImplementation;
    private final Set failedDependencies;

    public UnsatisfiableDependenciesException(Class componentImplementation, Set failedDependencies) {
        super(componentImplementation.getName() + " doesn't have any satisfiable constructors. Unsatisfiable dependencies: " + failedDependencies);
        this.componentImplementation = componentImplementation;
        this.failedDependencies = failedDependencies;
    }

    public Class getUnsatisfiableComponentImplementation() {
        return this.componentImplementation;
    }

    public Set getUnsatisfiableDependencies() {
        return this.failedDependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnsatisfiableDependenciesException)) {
            return false;
        }
        UnsatisfiableDependenciesException noSatisfiableConstructorsException = (UnsatisfiableDependenciesException)o;
        if (!this.componentImplementation.equals(noSatisfiableConstructorsException.componentImplementation)) {
            return false;
        }
        return ((Object)this.failedDependencies).equals(noSatisfiableConstructorsException.failedDependencies);
    }

    public int hashCode() {
        int result = this.componentImplementation.hashCode();
        result = 29 * result + ((Object)this.failedDependencies).hashCode();
        return result;
    }
}

