/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.DecoratingComponentAdapterFactory;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class BeanPropertyComponentAdapterFactory
extends DecoratingComponentAdapterFactory {
    private Map componentProperties = new HashMap();
    private Map adapterCache = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$net$URL;

    public BeanPropertyComponentAdapterFactory(ComponentAdapterFactory delegate) {
        super(delegate);
    }

    public ComponentAdapter createComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        ComponentAdapter decoratedAdapter = super.createComponentAdapter(componentKey, componentImplementation, parameters);
        Map propertyMap = (Map)this.componentProperties.get(componentKey);
        Adapter propertyAdapter = new Adapter(decoratedAdapter, propertyMap);
        this.adapterCache.put(componentKey, propertyAdapter);
        return propertyAdapter;
    }

    public void setProperties(Object componentKey, Map properties) {
        this.componentProperties.put(componentKey, properties);
    }

    public Adapter getComponentAdapter(Object key) {
        return (Adapter)this.adapterCache.get(key);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Adapter
    extends DecoratingComponentAdapter {
        private Map properties;
        private PropertyDescriptor[] propertyDescriptors;
        private Map propertyDescriptorMap = new HashMap();

        public Adapter(ComponentAdapter delegate, Map propertyValues) throws PicoBeanInfoInitializationException {
            super(delegate);
            this.properties = propertyValues;
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(delegate.getComponentImplementation());
                this.propertyDescriptors = beanInfo.getPropertyDescriptors();
                for (int i = 0; i < this.propertyDescriptors.length; ++i) {
                    PropertyDescriptor propertyDescriptor = this.propertyDescriptors[i];
                    this.propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
                }
            }
            catch (IntrospectionException e) {
                throw new PicoBeanInfoInitializationException("Couldn't load BeanInfo for" + delegate.getComponentImplementation().getName(), e);
            }
        }

        public Object getComponentInstance() throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
            Object componentInstance = super.getComponentInstance();
            if (this.properties != null) {
                Set propertyNames = this.properties.keySet();
                Iterator iterator = propertyNames.iterator();
                while (iterator.hasNext()) {
                    String propertyName = (String)iterator.next();
                    Object propertyValue = this.properties.get(propertyName);
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.propertyDescriptorMap.get(propertyName);
                    if (propertyDescriptor == null) {
                        throw new PicoIntrospectionException("Unknown property '" + propertyName + "' in class " + componentInstance.getClass().getName());
                    }
                    Method setter = propertyDescriptor.getWriteMethod();
                    if (setter == null) {
                        throw new PicoInitializationException("There is no public setter method for property " + propertyName + " in " + componentInstance.getClass().getName() + ". Setter: " + propertyDescriptor.getWriteMethod() + ". Getter: " + propertyDescriptor.getReadMethod());
                    }
                    try {
                        setter.invoke(componentInstance, this.convertType(setter, propertyValue));
                    }
                    catch (Exception e) {
                        throw new PicoInitializationException("Failed to set property " + propertyName + " to " + propertyValue + ": " + e.getMessage(), e);
                    }
                }
            }
            return componentInstance;
        }

        private Object convertType(Method setter, Object propertyValue) throws MalformedURLException {
            Object component;
            if (propertyValue == null) {
                return null;
            }
            Class<?> type = setter.getParameterTypes()[0];
            if (type.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanPropertyComponentAdapterFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean) || type.equals(Boolean.TYPE)) {
                return Boolean.valueOf(propertyValue.toString());
            }
            if (type.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanPropertyComponentAdapterFactory.class$("java.lang.Byte")) : class$java$lang$Byte) || type.equals(Byte.TYPE)) {
                return Byte.valueOf(propertyValue.toString());
            }
            if (type.equals(class$java$lang$Short == null ? (class$java$lang$Short = BeanPropertyComponentAdapterFactory.class$("java.lang.Short")) : class$java$lang$Short) || type.equals(Short.TYPE)) {
                return Short.valueOf(propertyValue.toString());
            }
            if (type.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanPropertyComponentAdapterFactory.class$("java.lang.Integer")) : class$java$lang$Integer) || type.equals(Integer.TYPE)) {
                return Integer.valueOf(propertyValue.toString());
            }
            if (type.equals(class$java$lang$Long == null ? (class$java$lang$Long = BeanPropertyComponentAdapterFactory.class$("java.lang.Long")) : class$java$lang$Long) || type.equals(Long.TYPE)) {
                return Long.valueOf(propertyValue.toString());
            }
            if (type.equals(class$java$lang$Float == null ? (class$java$lang$Float = BeanPropertyComponentAdapterFactory.class$("java.lang.Float")) : class$java$lang$Float) || type.equals(Float.TYPE)) {
                return Float.valueOf(propertyValue.toString());
            }
            if (type.equals(class$java$lang$Double == null ? (class$java$lang$Double = BeanPropertyComponentAdapterFactory.class$("java.lang.Double")) : class$java$lang$Double) || type.equals(Double.TYPE)) {
                return Double.valueOf(propertyValue.toString());
            }
            if (type.equals(class$java$lang$Character == null ? (class$java$lang$Character = BeanPropertyComponentAdapterFactory.class$("java.lang.Character")) : class$java$lang$Character) || type.equals(Character.TYPE)) {
                return new Character(propertyValue.toString().toCharArray()[0]);
            }
            if ((class$java$io$File == null ? (class$java$io$File = BeanPropertyComponentAdapterFactory.class$("java.io.File")) : class$java$io$File).isAssignableFrom(type)) {
                return new File(propertyValue.toString());
            }
            if ((class$java$net$URL == null ? (class$java$net$URL = BeanPropertyComponentAdapterFactory.class$("java.net.URL")) : class$java$net$URL).isAssignableFrom(type)) {
                return new URL(propertyValue.toString());
            }
            if (this.getContainer() != null && (component = this.getContainer().getComponentInstance(propertyValue)) != null && type.isAssignableFrom(component.getClass())) {
                return component;
            }
            return propertyValue;
        }

        public void setProperties(Map properties) {
            this.properties = properties;
        }
    }

    public static class NoSuchPropertyException
    extends PicoInitializationException {
    }

    public static class PicoBeanInfoInitializationException
    extends PicoIntrospectionException {
        protected PicoBeanInfoInitializationException(String message, Exception cause) {
            super(message, cause);
        }
    }
}

