/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Field;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class ConstantParameter
implements Parameter {
    private final Object value;

    public ConstantParameter(Object value) {
        this.value = value;
    }

    public ComponentAdapter resolveAdapter(PicoContainer picoContainer, Class expectedType) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        InstanceComponentAdapter result = null;
        if (expectedType.isAssignableFrom(this.value.getClass())) {
            result = new InstanceComponentAdapter((Object)this.uniqueishKey(), this.value);
        } else if (expectedType.isPrimitive()) {
            try {
                Field field = this.value.getClass().getField("TYPE");
                Class type = (Class)field.get(this.value);
                result = expectedType.isAssignableFrom(type) ? new InstanceComponentAdapter((Object)this.uniqueishKey(), this.value) : null;
            }
            catch (NoSuchFieldException e) {
                result = null;
            }
            catch (IllegalArgumentException e) {
                result = null;
            }
            catch (IllegalAccessException e) {
                result = null;
            }
            catch (ClassCastException e) {
                result = null;
            }
        }
        return result;
    }

    private Integer uniqueishKey() {
        return new Integer(System.identityHashCode(this.value));
    }
}

