/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ConstructorComponentAdapter
extends InstantiatingComponentAdapter {
    public ConstructorComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters);
    }

    public ConstructorComponentAdapter(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentImplementation, null);
    }

    protected Class[] getMostSatisfiableDependencyTypes(PicoContainer dependencyContainer) throws PicoIntrospectionException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Constructor constructor = this.getGreediestSatisifableConstructor(dependencyContainer);
        return constructor.getParameterTypes();
    }

    protected Constructor getGreediestSatisifableConstructor(PicoContainer dependencyContainer) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Constructor[] allConstructors = this.getComponentImplementation().getConstructors();
        List satisfiableConstructors = this.getAllSatisfiableConstructors(allConstructors, dependencyContainer);
        int arity = this.parameters == null ? -1 : this.parameters.length;
        Constructor greediestConstructor = null;
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        HashSet<Constructor> nonMatching = new HashSet<Constructor>();
        for (int i = 0; i < satisfiableConstructors.size(); ++i) {
            Constructor currentConstructor = (Constructor)satisfiableConstructors.get(i);
            Class<?>[] parameterTypes = currentConstructor.getParameterTypes();
            if (arity >= 0) {
                int j;
                if (arity != parameterTypes.length) continue;
                for (j = 0; j < arity; ++j) {
                    ComponentAdapter adapter = this.parameters[j].resolveAdapter(dependencyContainer, parameterTypes[j]);
                    if (adapter != null) continue;
                    nonMatching.add(currentConstructor);
                    break;
                }
                if (j != arity) continue;
                if (greediestConstructor == null) {
                    greediestConstructor = currentConstructor;
                    continue;
                }
                conflicts.add(greediestConstructor);
                conflicts.add(currentConstructor);
                continue;
            }
            if (greediestConstructor == null) {
                greediestConstructor = currentConstructor;
                continue;
            }
            if (greediestConstructor.getParameterTypes().length < parameterTypes.length) {
                conflicts.clear();
                greediestConstructor = currentConstructor;
                continue;
            }
            if (greediestConstructor.getParameterTypes().length != parameterTypes.length) continue;
            conflicts.add(greediestConstructor);
            conflicts.add(currentConstructor);
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        if (greediestConstructor == null && !nonMatching.isEmpty()) {
            throw new PicoInitializationException("The specified parameters do not match any of the following constructors: " + ((Object)nonMatching).toString());
        }
        return greediestConstructor;
    }

    private List getAllSatisfiableConstructors(Constructor[] constructors, PicoContainer picoContainer) throws PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        ArrayList<Constructor> satisfiableConstructors = new ArrayList<Constructor>();
        HashSet<List<Class>> unsatisfiableDependencyTypes = new HashSet<List<Class>>();
        for (int i = 0; i < constructors.length; ++i) {
            boolean failedDependency = false;
            Constructor constructor = constructors[i];
            Class[] parameterTypes = constructor.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : InstantiatingComponentAdapter.createDefaultParameters(parameterTypes, picoContainer);
            for (int j = 0; j < currentParameters.length && j < parameterTypes.length; ++j) {
                ComponentAdapter adapter = currentParameters[j].resolveAdapter(picoContainer, parameterTypes[j]);
                if (adapter == null) {
                    failedDependency = true;
                    unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                    continue;
                }
                if (adapter.equals(this)) {
                    failedDependency = true;
                    unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                }
                if (!this.getComponentKey().equals(adapter.getComponentKey())) continue;
                failedDependency = true;
                unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
            }
            if (failedDependency) continue;
            satisfiableConstructors.add(constructor);
        }
        if (satisfiableConstructors.isEmpty()) {
            throw new UnsatisfiableDependenciesException(this, unsatisfiableDependencyTypes);
        }
        return satisfiableConstructors;
    }

    protected Object[] getConstructorArguments(ComponentAdapter[] adapterDependencies) {
        Object[] result = new Object[adapterDependencies.length];
        for (int i = 0; i < adapterDependencies.length; ++i) {
            ComponentAdapter adapterDependency = adapterDependencies[i];
            result[i] = adapterDependency.getComponentInstance();
        }
        return result;
    }
}

