/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Disposable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoRegistrationException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.Startable;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class DefaultPicoContainer
implements MutablePicoContainer,
Serializable {
    private final Map componentKeyToAdapterCache = new HashMap();
    private final ComponentAdapterFactory componentAdapterFactory;
    private PicoContainer parent;
    private final List componentAdapters = new ArrayList();
    private final List orderedComponentAdapters = new ArrayList();
    private boolean started = false;
    private boolean disposed = false;
    static /* synthetic */ Class class$org$picocontainer$Startable;
    static /* synthetic */ Class class$org$picocontainer$Disposable;
    static /* synthetic */ Class class$org$picocontainer$PicoContainer;

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory, PicoContainer parent) {
        this.componentAdapterFactory = componentAdapterFactory;
        this.parent = parent;
    }

    public DefaultPicoContainer(PicoContainer parent) {
        this(new DefaultComponentAdapterFactory(), parent);
    }

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory) {
        this(componentAdapterFactory, null);
    }

    public DefaultPicoContainer() {
        this(new DefaultComponentAdapterFactory(), null);
    }

    public Collection getComponentAdapters() {
        return Collections.unmodifiableList(this.componentAdapters);
    }

    public final ComponentAdapter getComponentAdapter(Object componentKey) throws AmbiguousComponentResolutionException {
        ComponentAdapter adapter = (ComponentAdapter)this.componentKeyToAdapterCache.get(componentKey);
        if (adapter == null && this.parent != null) {
            adapter = this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        ComponentAdapter adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        ArrayList<ComponentAdapter> found = new ArrayList<ComponentAdapter>();
        Iterator iterator = this.getComponentAdapters().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            found.add(componentAdapter);
        }
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        if (found.size() == 0) {
            if (this.parent != null) {
                return this.parent.getComponentAdapterOfType(componentType);
            }
            return null;
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            ComponentAdapter componentAdapter = (ComponentAdapter)found.get(i);
            foundClasses[i] = componentAdapter.getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public void registerComponent(ComponentAdapter componentAdapter) throws DuplicateComponentKeyRegistrationException {
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.containsKey(componentKey)) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        componentAdapter.setContainer(this);
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
    }

    public ComponentAdapter unregisterComponent(Object componentKey) {
        ComponentAdapter adapter = (ComponentAdapter)this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        this.orderedComponentAdapters.remove(adapter);
        return adapter;
    }

    public ComponentAdapter registerComponentInstance(Object component) throws PicoRegistrationException {
        return this.registerComponentInstance(component.getClass(), component);
    }

    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) throws PicoRegistrationException {
        if (componentInstance == this) {
            throw new PicoRegistrationException("Cannot register a container to itself. The container is already implicitly registered.");
        }
        InstanceComponentAdapter componentAdapter = new InstanceComponentAdapter(componentKey, componentInstance);
        this.registerComponent(componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter registerComponentImplementation(Class componentImplementation) throws PicoRegistrationException {
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation) throws PicoRegistrationException {
        return this.registerComponentImplementation(componentKey, componentImplementation, (Parameter[])null);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, Parameter[] parameters) throws PicoRegistrationException {
        ComponentAdapter componentAdapter = this.componentAdapterFactory.createComponentAdapter(componentKey, componentImplementation, parameters);
        this.registerComponent(componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, List parameters) throws PicoRegistrationException {
        Parameter[] parametersAsArray = parameters.toArray(new Parameter[parameters.size()]);
        return this.registerComponentImplementation(componentKey, componentImplementation, parametersAsArray);
    }

    public void addOrderedComponentAdapter(ComponentAdapter componentAdapter) {
        if (!this.orderedComponentAdapters.contains(componentAdapter)) {
            this.orderedComponentAdapters.add(componentAdapter);
        }
    }

    public List getComponentInstances() throws PicoException {
        HashMap<ComponentAdapter, Object> adapterToInstanceMap = new HashMap<ComponentAdapter, Object>();
        Iterator iterator = this.componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            Object componentInstance = componentAdapter.getComponentInstance();
            adapterToInstanceMap.put(componentAdapter, componentInstance);
            this.addOrderedComponentAdapter(componentAdapter);
        }
        ArrayList result = new ArrayList();
        Iterator iterator2 = this.orderedComponentAdapters.iterator();
        while (iterator2.hasNext()) {
            Object componentAdapter = iterator2.next();
            Object componentInstance = adapterToInstanceMap.get(componentAdapter);
            if (componentInstance == null) continue;
            result.add(componentInstance);
        }
        return Collections.unmodifiableList(result);
    }

    public Object getComponentInstance(Object componentKey) throws PicoException {
        ComponentAdapter componentAdapter = this.getComponentAdapter(componentKey);
        if (componentAdapter != null) {
            return componentAdapter.getComponentInstance();
        }
        return null;
    }

    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : componentAdapter.getComponentInstance();
    }

    public PicoContainer getParent() {
        return this.parent;
    }

    public void setParent(PicoContainer parent) {
        this.parent = parent;
    }

    public ComponentAdapter unregisterComponentByInstance(Object componentInstance) {
        Collection componentAdapters = this.getComponentAdapters();
        Iterator iterator = componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            if (!componentAdapter.getComponentInstance().equals(componentInstance)) continue;
            return this.unregisterComponent(componentAdapter.getComponentKey());
        }
        return null;
    }

    public void verify() throws PicoVerificationException {
        ArrayList<UnsatisfiableDependenciesException> nestedVerificationExceptions = new ArrayList<UnsatisfiableDependenciesException>();
        Iterator iterator = this.getComponentAdapters().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            try {
                componentAdapter.verify();
            }
            catch (UnsatisfiableDependenciesException e) {
                nestedVerificationExceptions.add(e);
            }
        }
        if (!nestedVerificationExceptions.isEmpty()) {
            throw new PicoVerificationException(nestedVerificationExceptions);
        }
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        List componentAdapters = this.getComponentAdaptersWithContainerAdaptersLast();
        Iterator iterator = componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter;
            if (!(class$org$picocontainer$Startable == null ? DefaultPicoContainer.class$("org.picocontainer.Startable") : class$org$picocontainer$Startable).isAssignableFrom((componentAdapter = (ComponentAdapter)iterator.next()).getComponentImplementation())) continue;
            Startable startable = (Startable)componentAdapter.getComponentInstance();
            startable.start();
        }
        this.started = true;
    }

    public void stop() {
        if (!this.started) {
            throw new IllegalStateException("Not started");
        }
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        List componentAdapters = this.getComponentAdaptersWithContainerAdaptersLast();
        Collections.reverse(componentAdapters);
        Iterator iterator = componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter;
            if (!(class$org$picocontainer$Startable == null ? DefaultPicoContainer.class$("org.picocontainer.Startable") : class$org$picocontainer$Startable).isAssignableFrom((componentAdapter = (ComponentAdapter)iterator.next()).getComponentImplementation())) continue;
            Startable startable = (Startable)componentAdapter.getComponentInstance();
            startable.stop();
        }
        this.started = false;
    }

    public void dispose() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        List componentAdapters = this.getComponentAdaptersWithContainerAdaptersLast();
        Collections.reverse(componentAdapters);
        Iterator iterator = componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter;
            if (!(class$org$picocontainer$Disposable == null ? DefaultPicoContainer.class$("org.picocontainer.Disposable") : class$org$picocontainer$Disposable).isAssignableFrom((componentAdapter = (ComponentAdapter)iterator.next()).getComponentImplementation())) continue;
            Disposable disposable = (Disposable)componentAdapter.getComponentInstance();
            disposable.dispose();
        }
        this.disposed = true;
    }

    private List getComponentAdaptersWithContainerAdaptersLast() {
        ArrayList result = new ArrayList();
        result.addAll(this.getComponentAdapters());
        Collections.sort(result, new StackContainersAtEndComparator());
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class StackContainersAtEndComparator
    implements Comparator {
        StackContainersAtEndComparator() {
        }

        public int compare(Object o1, Object o2) {
            ComponentAdapter a1 = (ComponentAdapter)o1;
            ComponentAdapter a2 = (ComponentAdapter)o2;
            if ((class$org$picocontainer$PicoContainer == null ? (class$org$picocontainer$PicoContainer = DefaultPicoContainer.class$("org.picocontainer.PicoContainer")) : class$org$picocontainer$PicoContainer).isAssignableFrom(a1.getComponentImplementation())) {
                return 1;
            }
            if ((class$org$picocontainer$PicoContainer == null ? (class$org$picocontainer$PicoContainer = DefaultPicoContainer.class$("org.picocontainer.PicoContainer")) : class$org$picocontainer$PicoContainer).isAssignableFrom(a2.getComponentImplementation())) {
                return -1;
            }
            return 0;
        }
    }
}

