/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.alternatives;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class ImplementationHidingComponentAdapter
extends DecoratingComponentAdapter {
    private final boolean strict;

    public ImplementationHidingComponentAdapter(ComponentAdapter delegate, boolean strict) {
        super(delegate);
        this.strict = strict;
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object componentKey = this.getDelegate().getComponentKey();
        Class[] classes = null;
        if (componentKey instanceof Class && ((Class)this.getDelegate().getComponentKey()).isInterface()) {
            classes = new Class[]{(Class)this.getDelegate().getComponentKey()};
        } else if (componentKey instanceof Class[]) {
            classes = (Class[])componentKey;
        } else {
            if (this.strict) {
                throw new PicoIntrospectionException("In strict mode, " + this.getClass().getName() + " only allows components registered with interface keys (java.lang.Class or java.lang.Class[])");
            }
            return this.getDelegate().getComponentInstance(container);
        }
        Class[] interfaces = this.verifyInterfacesOnly(classes);
        return this.createProxy(interfaces, container);
    }

    private Object createProxy(Class[] interfaces, final PicoContainer container) {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Object componentInstance = ImplementationHidingComponentAdapter.this.getDelegate().getComponentInstance(container);
                    return method.invoke(componentInstance, args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
        });
    }

    private Class[] verifyInterfacesOnly(Class[] classes) {
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i].isInterface()) continue;
            throw new PicoIntrospectionException("Class keys must be interfaces. " + classes[i] + " is not an interface.");
        }
        return classes;
    }

    public static Class[] getAllInterfaces(Class clazz) {
        HashSet interfaces = new HashSet();
        ImplementationHidingComponentAdapter.getInterfaces(clazz, interfaces);
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    private static void getInterfaces(Class clazz, Set interfaces) {
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        while (clazz != null) {
            Class<?>[] implemented = clazz.getInterfaces();
            for (int i = 0; i < implemented.length; ++i) {
                if (interfaces.contains(implemented[i])) continue;
                ImplementationHidingComponentAdapter.getInterfaces(implemented[i], interfaces);
            }
            clazz = clazz.getSuperclass();
        }
    }
}

