/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AssignabilityRegistrationException;

public abstract class AbstractComponentAdapter
implements ComponentAdapter,
Serializable {
    private Object componentKey;
    private Class componentImplementation;

    protected AbstractComponentAdapter(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException {
        if (componentImplementation == null) {
            throw new NullPointerException("componentImplementation");
        }
        this.componentKey = componentKey;
        this.componentImplementation = componentImplementation;
        this.checkTypeCompatibility();
    }

    public Object getComponentKey() {
        if (this.componentKey == null) {
            throw new NullPointerException("componentKey");
        }
        return this.componentKey;
    }

    public Class getComponentImplementation() {
        return this.componentImplementation;
    }

    protected void checkTypeCompatibility() throws AssignabilityRegistrationException {
        Class componentType;
        if (this.componentKey instanceof Class && !(componentType = (Class)this.componentKey).isAssignableFrom(this.componentImplementation)) {
            throw new AssignabilityRegistrationException(componentType, this.componentImplementation);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getComponentKey() + "]";
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitComponentAdapter(this);
    }

    public abstract /* synthetic */ void verify(PicoContainer var1) throws PicoVerificationException;

    public abstract /* synthetic */ Object getComponentInstance(PicoContainer var1) throws PicoInitializationException, PicoIntrospectionException;
}

