/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedList;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInstantiationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.GenericCollectionComponentAdapter;

public class ComponentParameter
implements Parameter,
Serializable {
    private Object componentKey;

    public ComponentParameter(Object componentKey) {
        this.componentKey = componentKey;
    }

    public ComponentParameter() {
    }

    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) throws PicoInstantiationException {
        Object result = null;
        if (this.componentKey != null) {
            result = container.getComponentInstance(this.componentKey);
        } else {
            ComponentAdapter genericCA;
            result = container.getComponentInstanceOfType(expectedType);
            if (result == null && (genericCA = this.getGenericCollectionComponentAdapter(container, expectedType)) != null) {
                result = genericCA.getComponentInstance(container);
            }
        }
        return result;
    }

    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        return this.resolveAdapter(container, adapter, expectedType) != null;
    }

    private ComponentAdapter resolveAdapter(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter result = this.getTargetAdapter(container, expectedType);
        if (result == null) {
            return null;
        }
        if (adapter.getComponentKey().equals(result.getComponentKey())) {
            return null;
        }
        if (!expectedType.isAssignableFrom(result.getComponentImplementation())) {
            if (expectedType.isPrimitive()) {
                try {
                    Field field = result.getComponentImplementation().getField("TYPE");
                    Class type = (Class)field.get(result.getComponentInstance(null));
                    if (expectedType.isAssignableFrom(type)) {
                        return result;
                    }
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            return null;
        }
        return result;
    }

    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) throws PicoIntrospectionException {
        ComponentAdapter result = this.resolveAdapter(container, adapter, expectedType);
        if (result == null) {
            LinkedList<PicoIntrospectionException> list = new LinkedList<PicoIntrospectionException>();
            list.add(new PicoIntrospectionException(expectedType.getClass().getName() + "not resolvable"));
            throw new PicoVerificationException(list);
        }
        result.verify(container);
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    private ComponentAdapter getTargetAdapter(PicoContainer container, Class expectedType) {
        if (this.componentKey != null) {
            return container.getComponentAdapter(this.componentKey);
        }
        ComponentAdapter result = container.getComponentAdapterOfType(expectedType);
        if (result == null) {
            result = this.getGenericCollectionComponentAdapter(container, expectedType);
        }
        return result;
    }

    private ComponentAdapter getGenericCollectionComponentAdapter(PicoContainer container, Class expectedType) {
        Class<?> componentType = expectedType.getComponentType();
        if (container.getComponentAdaptersOfType(componentType).size() == 0) {
            return null;
        }
        Object[] componentKey = new Object[]{this, componentType};
        return new GenericCollectionComponentAdapter(componentKey, null, componentType, expectedType);
    }
}

