/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.LinkedList;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;

public class ConstantParameter
implements Parameter,
Serializable {
    private final Object value;

    public ConstantParameter(Object value) {
        this.value = value;
    }

    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        if (expectedType.isPrimitive()) {
            try {
                return this.checkPrimitive(expectedType);
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            return false;
        }
        return expectedType.isInstance(this.value);
    }

    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        return this.value;
    }

    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) throws PicoVerificationException {
        try {
            if (!(expectedType.isPrimitive() && this.checkPrimitive(expectedType) || expectedType.isInstance(this.value))) {
                throw new ClassCastException(this.value.toString() + " does not match the type " + expectedType.getClass().getName());
            }
        }
        catch (PicoVerificationException e) {
            throw e;
        }
        catch (Exception e) {
            LinkedList<Exception> list = new LinkedList<Exception>();
            list.add(e);
            throw new PicoVerificationException(list);
        }
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    private boolean checkPrimitive(Class expectedType) throws NoSuchFieldException, IllegalAccessException {
        Field field = this.value.getClass().getField("TYPE");
        Class type = (Class)field.get(this.value);
        return expectedType.isAssignableFrom(type);
    }
}

