/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AbstractComponentAdapter;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentParameter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.ThreadLocalCyclicDependencyGuard;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public abstract class InstantiatingComponentAdapter
extends AbstractComponentAdapter {
    protected transient Guard verifyingGuard;
    protected Parameter[] parameters;
    protected boolean allowNonPublicClasses;

    protected InstantiatingComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses) {
        super(componentKey, componentImplementation);
        this.checkConcrete();
        this.parameters = parameters;
        this.allowNonPublicClasses = allowNonPublicClasses;
    }

    private void checkConcrete() throws NotConcreteRegistrationException {
        boolean isAbstract;
        boolean bl = isAbstract = (this.getComponentImplementation().getModifiers() & 0x400) == 1024;
        if (this.getComponentImplementation().isInterface() || isAbstract) {
            throw new NotConcreteRegistrationException(this.getComponentImplementation());
        }
    }

    protected Parameter[] createDefaultParameters(Class[] parameters) {
        Parameter[] componentParameters = new Parameter[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            componentParameters[i] = new ComponentParameter();
        }
        return componentParameters;
    }

    public void verify(PicoContainer container) throws PicoVerificationException {
        try {
            if (this.verifyingGuard == null) {
                this.verifyingGuard = new Guard(){

                    public Object run() {
                        Constructor constructor = InstantiatingComponentAdapter.this.getGreediestSatisfiableConstructor(this.container);
                        Class[] parameterTypes = constructor.getParameterTypes();
                        Parameter[] currentParameters = InstantiatingComponentAdapter.this.parameters != null ? InstantiatingComponentAdapter.this.parameters : InstantiatingComponentAdapter.this.createDefaultParameters(parameterTypes);
                        for (int i = 0; i < currentParameters.length; ++i) {
                            currentParameters[i].verify(this.container, InstantiatingComponentAdapter.this, parameterTypes[i]);
                        }
                        return null;
                    }
                };
            }
            this.verifyingGuard.setArguments(container);
            this.verifyingGuard.observe(this.getComponentImplementation());
        }
        catch (PicoVerificationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LinkedList<Exception> list = new LinkedList<Exception>();
            list.add(ex);
            throw new PicoVerificationException(list);
        }
    }

    public void accept(PicoVisitor visitor) {
        if (visitor.isReverseTraversal()) {
            this.acceptParameters(visitor);
        }
        super.accept(visitor);
        if (!visitor.isReverseTraversal()) {
            this.acceptParameters(visitor);
        }
    }

    private void acceptParameters(PicoVisitor visitor) {
        block4: {
            if (this.parameters == null) break block4;
            if (!visitor.isReverseTraversal()) {
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.parameters[i].accept(visitor);
                }
            } else {
                int i = this.parameters.length;
                while (i-- > 0) {
                    this.parameters[i].accept(visitor);
                }
            }
        }
    }

    protected Object newInstance(Constructor constructor, Object[] parameters) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.allowNonPublicClasses) {
            ((AccessibleObject)constructor).setAccessible(true);
        }
        return constructor.newInstance(parameters);
    }

    protected abstract Constructor getGreediestSatisfiableConstructor(PicoContainer var1) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException;

    protected static abstract class Guard
    extends ThreadLocalCyclicDependencyGuard {
        protected PicoContainer container;

        protected Guard() {
        }

        protected void setArguments(PicoContainer container) {
            this.container = container;
        }
    }
}

