/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class LifecycleVisitor
implements PicoVisitor {
    public static final PicoVisitor STARTER;
    public static final PicoVisitor STOPPER;
    public static final PicoVisitor DISPOSER;
    private final Method method;
    private final Class type;
    private final boolean visitInInstantiationOrder;
    static /* synthetic */ Class class$org$picocontainer$Startable;
    static /* synthetic */ Class class$org$picocontainer$Disposable;

    public LifecycleVisitor(Method method, Class ofType, boolean visitInInstantiationOrder) {
        this.method = method;
        this.type = ofType;
        this.visitInInstantiationOrder = visitInInstantiationOrder;
    }

    public void visitContainer(PicoContainer pico) {
        LinkedList componentInstances = new LinkedList(pico.getComponentInstancesOfType(this.type));
        if (this.visitInInstantiationOrder) {
            this.visitComponentInstances(componentInstances);
        } else {
            Collections.reverse(componentInstances);
            this.visitComponentInstances(componentInstances);
        }
    }

    public void visitComponentAdapter(ComponentAdapter componentAdapter) {
    }

    public void visitParameter(Parameter parameter) {
    }

    private void visitComponentInstances(List componentInstances) {
        Iterator iterator = componentInstances.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            try {
                this.method.invoke(o, null);
            }
            catch (IllegalArgumentException e) {
                throw new PicoIntrospectionException("Can't call " + this.method.getName() + " on " + o, e);
            }
            catch (IllegalAccessException e) {
                throw new PicoIntrospectionException("Can't call " + this.method.getName() + " on " + o, e);
            }
            catch (InvocationTargetException e) {
                throw new PicoIntrospectionException("Failed when calling " + this.method.getName() + " on " + o, e.getTargetException());
            }
        }
    }

    public boolean isReverseTraversal() {
        return !this.visitInInstantiationOrder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            STARTER = new LifecycleVisitor((class$org$picocontainer$Startable == null ? (class$org$picocontainer$Startable = LifecycleVisitor.class$("org.picocontainer.Startable")) : class$org$picocontainer$Startable).getMethod("start", null), class$org$picocontainer$Startable == null ? (class$org$picocontainer$Startable = LifecycleVisitor.class$("org.picocontainer.Startable")) : class$org$picocontainer$Startable, true);
            STOPPER = new LifecycleVisitor((class$org$picocontainer$Startable == null ? (class$org$picocontainer$Startable = LifecycleVisitor.class$("org.picocontainer.Startable")) : class$org$picocontainer$Startable).getMethod("stop", null), class$org$picocontainer$Startable == null ? (class$org$picocontainer$Startable = LifecycleVisitor.class$("org.picocontainer.Startable")) : class$org$picocontainer$Startable, false);
            DISPOSER = new LifecycleVisitor((class$org$picocontainer$Disposable == null ? (class$org$picocontainer$Disposable = LifecycleVisitor.class$("org.picocontainer.Disposable")) : class$org$picocontainer$Disposable).getMethod("dispose", null), class$org$picocontainer$Disposable == null ? (class$org$picocontainer$Disposable = LifecycleVisitor.class$("org.picocontainer.Disposable")) : class$org$picocontainer$Disposable, false){

                public void visitContainer(PicoContainer pico) {
                    super.visitContainer(pico);
                    if (pico.getParent() instanceof MutablePicoContainer) {
                        ((MutablePicoContainer)pico.getParent()).removeChildContainer(pico);
                    }
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage());
        }
    }
}

