/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class CollectionComponentParameter
implements Parameter,
Serializable {
    public static final CollectionComponentParameter ARRAY = new CollectionComponentParameter();
    public static final CollectionComponentParameter ARRAY_ALLOW_EMPTY = new CollectionComponentParameter(true);
    private final boolean emptyCollection;
    private final Class componentKeyType;
    private final Class componentValueType;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$reflect$Array;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$TreeSet;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$HashSet;
    static /* synthetic */ Class class$java$util$SortedMap;
    static /* synthetic */ Class class$java$util$TreeMap;
    static /* synthetic */ Class class$java$util$HashMap;

    public CollectionComponentParameter() {
        this(false);
    }

    public CollectionComponentParameter(boolean emptyCollection) {
        this(Void.TYPE, emptyCollection);
    }

    public CollectionComponentParameter(Class componentValueType, boolean emptyCollection) {
        this(class$java$lang$Object == null ? (class$java$lang$Object = CollectionComponentParameter.class$("java.lang.Object")) : class$java$lang$Object, componentValueType, emptyCollection);
    }

    public CollectionComponentParameter(Class componentKeyType, Class componentValueType, boolean emptyCollection) {
        this.emptyCollection = emptyCollection;
        this.componentKeyType = componentKeyType;
        this.componentValueType = componentValueType;
    }

    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        Object result = null;
        Class collectionType = this.getCollectionType(expectedType);
        if (collectionType != null) {
            Map adapterMap = this.getMatchingComponentAdapters(container, adapter, this.componentKeyType, this.getValueType(expectedType));
            if ((class$java$lang$reflect$Array == null ? (class$java$lang$reflect$Array = CollectionComponentParameter.class$("java.lang.reflect.Array")) : class$java$lang$reflect$Array).isAssignableFrom(collectionType)) {
                result = this.getArrayInstance(container, expectedType, adapterMap);
            } else if ((class$java$util$Map == null ? (class$java$util$Map = CollectionComponentParameter.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(collectionType)) {
                result = this.getMapInstance(container, expectedType, adapterMap);
            } else if ((class$java$util$Collection == null ? (class$java$util$Collection = CollectionComponentParameter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(collectionType)) {
                result = this.getCollectionInstance(container, expectedType, adapterMap);
            } else {
                throw new PicoIntrospectionException(expectedType.getName() + " is not a collective type");
            }
        }
        return result;
    }

    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        Class collectionType = this.getCollectionType(expectedType);
        Class valueType = this.getValueType(expectedType);
        return collectionType != null && (this.emptyCollection || this.getMatchingComponentAdapters(container, adapter, this.componentKeyType, valueType).size() > 0);
    }

    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        Class collectionType = this.getCollectionType(expectedType);
        if (collectionType != null) {
            Class valueType = this.getValueType(expectedType);
            Collection componentAdapters = this.getMatchingComponentAdapters(container, adapter, this.componentKeyType, valueType).values();
            if (componentAdapters.isEmpty()) {
                if (!this.emptyCollection) {
                    throw new PicoIntrospectionException(expectedType.getName() + " not resolvable, no components of type " + this.getValueType(expectedType).getName() + " available");
                }
            } else {
                Iterator iter = componentAdapters.iterator();
                while (iter.hasNext()) {
                    ComponentAdapter componentAdapter = (ComponentAdapter)iter.next();
                    componentAdapter.verify(container);
                }
            }
        } else {
            throw new PicoIntrospectionException(expectedType.getName() + " is not a collective type");
        }
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    protected boolean evaluate(ComponentAdapter adapter) {
        return adapter != null;
    }

    protected Map getMatchingComponentAdapters(PicoContainer container, ComponentAdapter adapter, Class keyType, Class valueType) {
        HashMap<Object, ComponentAdapter> adapterMap = new HashMap<Object, ComponentAdapter>();
        PicoContainer parent = container.getParent();
        if (parent != null) {
            adapterMap.putAll(this.getMatchingComponentAdapters(parent, adapter, keyType, valueType));
        }
        Collection allAdapters = container.getComponentAdapters();
        Iterator iter = allAdapters.iterator();
        while (iter.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iter.next();
            adapterMap.remove(componentAdapter.getComponentKey());
        }
        List adapterList = container.getComponentAdaptersOfType(valueType);
        Iterator iter2 = adapterList.iterator();
        while (iter2.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iter2.next();
            Object key = componentAdapter.getComponentKey();
            if (adapter != null && key.equals(adapter.getComponentKey()) || !keyType.isAssignableFrom(key.getClass()) || !this.evaluate(componentAdapter)) continue;
            adapterMap.put(key, componentAdapter);
        }
        return adapterMap;
    }

    private Class getCollectionType(Class collectionType) {
        Class collectionClass = null;
        if (collectionType.isArray()) {
            collectionClass = class$java$lang$reflect$Array == null ? (class$java$lang$reflect$Array = CollectionComponentParameter.class$("java.lang.reflect.Array")) : class$java$lang$reflect$Array;
        } else if ((class$java$util$Map == null ? (class$java$util$Map = CollectionComponentParameter.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(collectionType)) {
            collectionClass = class$java$util$Map == null ? (class$java$util$Map = CollectionComponentParameter.class$("java.util.Map")) : class$java$util$Map;
        } else if ((class$java$util$Collection == null ? (class$java$util$Collection = CollectionComponentParameter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(collectionType)) {
            collectionClass = class$java$util$Collection == null ? (class$java$util$Collection = CollectionComponentParameter.class$("java.util.Collection")) : class$java$util$Collection;
        }
        return collectionClass;
    }

    private Class getValueType(Class collectionType) {
        Class<?> valueType = this.componentValueType;
        if (collectionType.isArray()) {
            valueType = collectionType.getComponentType();
        }
        return valueType;
    }

    private Object[] getArrayInstance(PicoContainer container, Class expectedType, Map adapterList) {
        Object[] result = (Object[])Array.newInstance(expectedType.getComponentType(), adapterList.size());
        int i = 0;
        Iterator iterator = adapterList.values().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            result[i] = container.getComponentInstance(componentAdapter.getComponentKey());
            ++i;
        }
        return result;
    }

    private Collection getCollectionInstance(PicoContainer container, Class expectedType, Map adapterList) {
        Class collectionType = expectedType;
        if (collectionType.isInterface()) {
            if ((class$java$util$List == null ? (class$java$util$List = CollectionComponentParameter.class$("java.util.List")) : class$java$util$List).isAssignableFrom(collectionType)) {
                collectionType = class$java$util$ArrayList == null ? (class$java$util$ArrayList = CollectionComponentParameter.class$("java.util.ArrayList")) : class$java$util$ArrayList;
            } else if ((class$java$util$SortedSet == null ? (class$java$util$SortedSet = CollectionComponentParameter.class$("java.util.SortedSet")) : class$java$util$SortedSet).isAssignableFrom(collectionType)) {
                collectionType = class$java$util$TreeSet == null ? (class$java$util$TreeSet = CollectionComponentParameter.class$("java.util.TreeSet")) : class$java$util$TreeSet;
            } else if ((class$java$util$Set == null ? (class$java$util$Set = CollectionComponentParameter.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(collectionType)) {
                collectionType = class$java$util$HashSet == null ? (class$java$util$HashSet = CollectionComponentParameter.class$("java.util.HashSet")) : class$java$util$HashSet;
            } else if ((class$java$util$Collection == null ? (class$java$util$Collection = CollectionComponentParameter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(collectionType)) {
                collectionType = class$java$util$ArrayList == null ? (class$java$util$ArrayList = CollectionComponentParameter.class$("java.util.ArrayList")) : class$java$util$ArrayList;
            }
        }
        try {
            Collection result = (Collection)collectionType.newInstance();
            Iterator iterator = adapterList.values().iterator();
            while (iterator.hasNext()) {
                ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
                result.add(container.getComponentInstance(componentAdapter.getComponentKey()));
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new PicoInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
    }

    private Map getMapInstance(PicoContainer container, Class expectedType, Map adapterList) {
        Class collectionType = expectedType;
        if (collectionType.isInterface()) {
            if ((class$java$util$SortedMap == null ? (class$java$util$SortedMap = CollectionComponentParameter.class$("java.util.SortedMap")) : class$java$util$SortedMap).isAssignableFrom(collectionType)) {
                collectionType = class$java$util$TreeMap == null ? (class$java$util$TreeMap = CollectionComponentParameter.class$("java.util.TreeMap")) : class$java$util$TreeMap;
            } else if ((class$java$util$Map == null ? (class$java$util$Map = CollectionComponentParameter.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(collectionType)) {
                collectionType = class$java$util$HashMap == null ? (class$java$util$HashMap = CollectionComponentParameter.class$("java.util.HashMap")) : class$java$util$HashMap;
            }
        }
        try {
            Map result = (Map)collectionType.newInstance();
            Iterator iterator = adapterList.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object key = entry.getKey();
                result.put(key, container.getComponentInstance(key));
            }
            return result;
        }
        catch (InstantiationException e) {
            throw new PicoInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new PicoInitializationException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

