/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.LifecycleManager;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.ComponentMonitorStrategy;
import org.picocontainer.defaults.DefaultComponentAdapterFactory;
import org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.ImmutablePicoContainerProxyFactory;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.VerifyingVisitor;
import org.picocontainer.monitors.NullComponentMonitor;

public class DefaultPicoContainer
implements MutablePicoContainer,
ComponentMonitorStrategy,
Serializable {
    private Map componentKeyToAdapterCache = new HashMap();
    private ComponentAdapterFactory componentAdapterFactory;
    private PicoContainer parent;
    private List componentAdapters = new ArrayList();
    private List orderedComponentAdapters = new ArrayList();
    private boolean started = false;
    private boolean disposed = false;
    private HashSet children = new HashSet();
    private LifecycleManager lifecycleManager = new OrderedComponentAdapterLifecycleManager();
    private LifecycleStrategy lifecycleStrategyForInstanceRegistrations = new DefaultLifecycleStrategy();
    static /* synthetic */ Class class$java$lang$Object;

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory, PicoContainer parent) {
        if (componentAdapterFactory == null) {
            throw new NullPointerException("componentAdapterFactory");
        }
        this.componentAdapterFactory = componentAdapterFactory;
        this.parent = parent == null ? null : ImmutablePicoContainerProxyFactory.newProxyInstance(parent);
    }

    public DefaultPicoContainer(ComponentMonitor componentMonitor, PicoContainer parent) {
        this(new DefaultComponentAdapterFactory(componentMonitor), parent);
    }

    public DefaultPicoContainer(ComponentMonitor componentMonitor, LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
        this(new DefaultComponentAdapterFactory(componentMonitor, lifecycleStrategy), parent);
        this.lifecycleStrategyForInstanceRegistrations = lifecycleStrategy;
    }

    public DefaultPicoContainer(LifecycleStrategy lifecycleStrategy, PicoContainer parent) {
        this(new NullComponentMonitor(), lifecycleStrategy, parent);
    }

    public DefaultPicoContainer(ComponentAdapterFactory componentAdapterFactory) {
        this(componentAdapterFactory, null);
    }

    public DefaultPicoContainer(ComponentMonitor componentMonitor) {
        this(new DefaultComponentAdapterFactory(componentMonitor), null);
    }

    public DefaultPicoContainer(PicoContainer parent) {
        this(new DefaultComponentAdapterFactory(), parent);
    }

    public DefaultPicoContainer() {
        this(new DefaultComponentAdapterFactory(), null);
    }

    public Collection getComponentAdapters() {
        return Collections.unmodifiableList(this.componentAdapters);
    }

    public final ComponentAdapter getComponentAdapter(Object componentKey) {
        ComponentAdapter adapter = (ComponentAdapter)this.componentKeyToAdapterCache.get(componentKey);
        if (adapter == null && this.parent != null) {
            adapter = this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        ComponentAdapter adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        List found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        if (found.size() == 0) {
            if (this.parent != null) {
                return this.parent.getComponentAdapterOfType(componentType);
            }
            return null;
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = ((ComponentAdapter)found.get(i)).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public List getComponentAdaptersOfType(Class componentType) {
        if (componentType == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ComponentAdapter> found = new ArrayList<ComponentAdapter>();
        Iterator iterator = this.getComponentAdapters().iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            found.add(componentAdapter);
        }
        return found;
    }

    public ComponentAdapter registerComponent(ComponentAdapter componentAdapter) {
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.containsKey(componentKey)) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter unregisterComponent(Object componentKey) {
        ComponentAdapter adapter = (ComponentAdapter)this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        this.orderedComponentAdapters.remove(adapter);
        return adapter;
    }

    public ComponentAdapter registerComponentInstance(Object component) {
        return this.registerComponentInstance(component.getClass(), component);
    }

    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) {
        InstanceComponentAdapter componentAdapter = new InstanceComponentAdapter(componentKey, componentInstance, this.lifecycleStrategyForInstanceRegistrations);
        this.registerComponent(componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter registerComponentImplementation(Class componentImplementation) {
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation) {
        return this.registerComponentImplementation(componentKey, componentImplementation, (Parameter[])null);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, Parameter[] parameters) {
        ComponentAdapter componentAdapter = this.componentAdapterFactory.createComponentAdapter(componentKey, componentImplementation, parameters);
        this.registerComponent(componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, List parameters) {
        Parameter[] parametersAsArray = parameters.toArray(new Parameter[parameters.size()]);
        return this.registerComponentImplementation(componentKey, componentImplementation, parametersAsArray);
    }

    private void addOrderedComponentAdapter(ComponentAdapter componentAdapter) {
        if (!this.orderedComponentAdapters.contains(componentAdapter)) {
            this.orderedComponentAdapters.add(componentAdapter);
        }
    }

    public List getComponentInstances() throws PicoException {
        return this.getComponentInstancesOfType(class$java$lang$Object == null ? (class$java$lang$Object = DefaultPicoContainer.class$("java.lang.Object")) : class$java$lang$Object);
    }

    public List getComponentInstancesOfType(Class componentType) {
        if (componentType == null) {
            return Collections.EMPTY_LIST;
        }
        HashMap<ComponentAdapter, Object> adapterToInstanceMap = new HashMap<ComponentAdapter, Object>();
        Iterator iterator = this.componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            if (!componentType.isAssignableFrom(componentAdapter.getComponentImplementation())) continue;
            Object componentInstance = this.getInstance(componentAdapter);
            adapterToInstanceMap.put(componentAdapter, componentInstance);
            this.addOrderedComponentAdapter(componentAdapter);
        }
        ArrayList result = new ArrayList();
        Iterator iterator2 = this.orderedComponentAdapters.iterator();
        while (iterator2.hasNext()) {
            Object componentAdapter = iterator2.next();
            Object componentInstance = adapterToInstanceMap.get(componentAdapter);
            if (componentInstance == null) continue;
            result.add(componentInstance);
        }
        return result;
    }

    public Object getComponentInstance(Object componentKey) {
        ComponentAdapter componentAdapter = this.getComponentAdapter(componentKey);
        if (componentAdapter != null) {
            return this.getInstance(componentAdapter);
        }
        return null;
    }

    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    private Object getInstance(ComponentAdapter componentAdapter) {
        boolean isLocal = this.componentAdapters.contains(componentAdapter);
        if (isLocal) {
            Object instance = null;
            try {
                instance = componentAdapter.getComponentInstance(this);
            }
            catch (PicoInitializationException e) {
                if (this.parent != null) {
                    return this.parent.getComponentInstance(componentAdapter.getComponentKey());
                }
                throw e;
            }
            catch (PicoIntrospectionException e) {
                if (this.parent != null) {
                    return this.parent.getComponentInstance(componentAdapter.getComponentKey());
                }
                throw e;
            }
            this.addOrderedComponentAdapter(componentAdapter);
            return instance;
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    public PicoContainer getParent() {
        return this.parent;
    }

    public ComponentAdapter unregisterComponentByInstance(Object componentInstance) {
        Collection componentAdapters = this.getComponentAdapters();
        Iterator iterator = componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            if (!this.getInstance(componentAdapter).equals(componentInstance)) continue;
            return this.unregisterComponent(componentAdapter.getComponentKey());
        }
        return null;
    }

    public void verify() throws PicoVerificationException {
        new VerifyingVisitor().traverse(this);
    }

    public void start() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        if (this.started) {
            throw new IllegalStateException("Already started");
        }
        this.lifecycleManager.start(this);
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            PicoContainer child = (PicoContainer)iterator.next();
            child.start();
        }
        this.started = true;
    }

    public void stop() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        if (!this.started) {
            throw new IllegalStateException("Not started");
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            PicoContainer child = (PicoContainer)iterator.next();
            child.stop();
        }
        this.lifecycleManager.stop(this);
        this.started = false;
    }

    public void dispose() {
        if (this.disposed) {
            throw new IllegalStateException("Already disposed");
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            PicoContainer child = (PicoContainer)iterator.next();
            child.dispose();
        }
        this.lifecycleManager.dispose(this);
        this.disposed = true;
    }

    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer pc = new DefaultPicoContainer(this.componentAdapterFactory, (PicoContainer)this);
        this.addChildContainer(pc);
        return pc;
    }

    public boolean addChildContainer(PicoContainer child) {
        return this.children.add(child);
    }

    public boolean removeChildContainer(PicoContainer child) {
        boolean result = this.children.remove(child);
        return result;
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitContainer(this);
        ArrayList componentAdapters = new ArrayList(this.getComponentAdapters());
        Iterator iterator = componentAdapters.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter componentAdapter = (ComponentAdapter)iterator.next();
            componentAdapter.accept(visitor);
        }
        ArrayList allChildren = new ArrayList(this.children);
        Iterator iterator2 = allChildren.iterator();
        while (iterator2.hasNext()) {
            PicoContainer child = (PicoContainer)iterator2.next();
            child.accept(visitor);
        }
    }

    public void changeMonitor(ComponentMonitor monitor) {
        if (this.componentAdapterFactory instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.componentAdapterFactory)).changeMonitor(monitor);
        }
        Iterator i = this.componentAdapters.iterator();
        while (i.hasNext()) {
            Object adapter = i.next();
            if (!(adapter instanceof ComponentMonitorStrategy)) continue;
            ((ComponentMonitorStrategy)adapter).changeMonitor(monitor);
        }
        i = this.children.iterator();
        while (i.hasNext()) {
            Object child = i.next();
            if (!(child instanceof ComponentMonitorStrategy)) continue;
            ((ComponentMonitorStrategy)child).changeMonitor(monitor);
        }
    }

    public ComponentMonitor currentMonitor() {
        if (this.componentAdapterFactory instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)((Object)this.componentAdapterFactory)).currentMonitor();
        }
        Iterator i = this.componentAdapters.iterator();
        while (i.hasNext()) {
            Object adapter = i.next();
            if (!(adapter instanceof ComponentMonitorStrategy)) continue;
            return ((ComponentMonitorStrategy)adapter).currentMonitor();
        }
        i = this.children.iterator();
        while (i.hasNext()) {
            Object child = i.next();
            if (!(child instanceof ComponentMonitorStrategy)) continue;
            return ((ComponentMonitorStrategy)child).currentMonitor();
        }
        throw new PicoIntrospectionException("No component monitor found in container or its children");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class OrderedComponentAdapterLifecycleManager
    implements LifecycleManager,
    Serializable {
        private OrderedComponentAdapterLifecycleManager() {
        }

        public void start(PicoContainer node) {
            List adapters = this.getOrderedComponentAdapters();
            for (int i = 0; i < adapters.size(); ++i) {
                Object adapter = adapters.get(i);
                if (!(adapter instanceof LifecycleManager)) continue;
                LifecycleManager manager = (LifecycleManager)adapter;
                manager.start(node);
            }
        }

        public void stop(PicoContainer node) {
            List adapters = this.getOrderedComponentAdapters();
            for (int i = adapters.size() - 1; 0 <= i; --i) {
                Object adapter = adapters.get(i);
                if (!(adapter instanceof LifecycleManager)) continue;
                LifecycleManager manager = (LifecycleManager)adapter;
                manager.stop(node);
            }
        }

        public void dispose(PicoContainer node) {
            List adapters = this.getOrderedComponentAdapters();
            for (int i = adapters.size() - 1; 0 <= i; --i) {
                Object adapter = adapters.get(i);
                if (!(adapter instanceof LifecycleManager)) continue;
                LifecycleManager manager = (LifecycleManager)adapter;
                manager.dispose(node);
            }
        }

        private List getOrderedComponentAdapters() {
            DefaultPicoContainer.this.getComponentInstances();
            return DefaultPicoContainer.this.orderedComponentAdapters;
        }
    }
}

