/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.picocontainer.ComponentMonitor;
import org.picocontainer.defaults.ComponentMonitorStrategy;
import org.picocontainer.monitors.NullComponentMonitor;

public class DelegatingComponentMonitor
implements ComponentMonitor,
ComponentMonitorStrategy,
Serializable {
    private ComponentMonitor delegate;

    public DelegatingComponentMonitor(ComponentMonitor delegate) {
        this.checkMonitor(delegate);
        this.delegate = delegate;
    }

    public DelegatingComponentMonitor() {
        this(NullComponentMonitor.getInstance());
    }

    public void instantiating(Constructor constructor) {
        this.delegate.instantiating(constructor);
    }

    public void instantiated(Constructor constructor, long duration) {
        this.delegate.instantiated(constructor, duration);
    }

    public void instantiationFailed(Constructor constructor, Exception e) {
        this.delegate.instantiationFailed(constructor, e);
    }

    public void invoking(Method method, Object instance) {
        this.delegate.invoking(method, instance);
    }

    public void invoked(Method method, Object instance, long duration) {
        this.delegate.invoked(method, instance, duration);
    }

    public void invocationFailed(Method method, Object instance, Exception e) {
        this.delegate.invocationFailed(method, instance, e);
    }

    public void changeMonitor(ComponentMonitor monitor) {
        this.checkMonitor(monitor);
        if (this.delegate instanceof ComponentMonitorStrategy) {
            ((ComponentMonitorStrategy)((Object)this.delegate)).changeMonitor(monitor);
        } else {
            this.delegate = monitor;
        }
    }

    public ComponentMonitor currentMonitor() {
        if (this.delegate instanceof ComponentMonitorStrategy) {
            return ((ComponentMonitorStrategy)((Object)this.delegate)).currentMonitor();
        }
        return this.delegate;
    }

    private void checkMonitor(ComponentMonitor monitor) {
        if (monitor == null) {
            throw new NullPointerException("monitor");
        }
    }
}

