/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import org.picocontainer.ComponentAdapter;
import org.picocontainer.LifecycleManager;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.ObjectReference;
import org.picocontainer.defaults.SimpleReference;

public class CachingComponentAdapter
extends DecoratingComponentAdapter
implements LifecycleManager {
    private ObjectReference instanceReference;
    private boolean disposed;
    private boolean started;
    private boolean delegateHasLifecylce;

    public CachingComponentAdapter(ComponentAdapter delegate) {
        this(delegate, new SimpleReference());
    }

    public CachingComponentAdapter(ComponentAdapter delegate, ObjectReference instanceReference) {
        super(delegate);
        this.instanceReference = instanceReference;
        this.disposed = false;
        this.started = false;
        this.delegateHasLifecylce = delegate instanceof LifecycleStrategy && ((LifecycleStrategy)((Object)delegate)).hasLifecycle(delegate.getComponentImplementation());
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.instanceReference.get() == null) {
            Object instance = super.getComponentInstance(container);
            this.instanceReference.set(instance);
        }
        return this.instanceReference.get();
    }

    public void flush() {
        Object instance = this.instanceReference.get();
        if (instance != null && this.delegateHasLifecylce && this.started) {
            this.stop(instance);
            this.dispose(instance);
        }
        this.instanceReference.set(null);
    }

    public void start(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            this.start(this.getComponentInstance(container));
            this.started = true;
        }
    }

    public void stop(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (!this.started) {
                throw new IllegalStateException("Not started");
            }
            this.stop(this.getComponentInstance(container));
            this.started = false;
        }
    }

    public void dispose(PicoContainer container) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            this.dispose(this.getComponentInstance(container));
            this.disposed = true;
        }
    }

    public boolean hasLifecycle() {
        return this.delegateHasLifecylce;
    }
}

