/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.SetterIntrospector;

public class BeanPropertyComponentAdapter
extends DecoratingComponentAdapter {
    private Map properties;
    private transient Map setters = null;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$Class;

    public BeanPropertyComponentAdapter(ComponentAdapter delegate) throws PicoInitializationException {
        super(delegate);
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object componentInstance = super.getComponentInstance(container);
        if (this.setters == null) {
            this.setters = new SetterIntrospector().getSetters(this.getComponentImplementation());
        }
        if (this.properties != null) {
            Set propertyNames = this.properties.keySet();
            Iterator iterator = propertyNames.iterator();
            while (iterator.hasNext()) {
                String propertyName = (String)iterator.next();
                String propertyValue = (String)this.properties.get(propertyName);
                Method setter = (Method)this.setters.get(propertyName);
                Object value = null;
                try {
                    value = this.convertType(container, setter, propertyValue);
                }
                catch (ClassNotFoundException e) {
                    throw new PicoInvocationTargetInitializationException(e);
                }
                try {
                    setter.invoke(componentInstance, value);
                }
                catch (Exception e) {
                    throw new PicoInitializationException("Failed to set property " + propertyName + " to " + propertyValue + ": " + e.getMessage(), e);
                }
            }
        }
        return componentInstance;
    }

    private Object convertType(PicoContainer container, Method setter, String propertyValue) throws ClassNotFoundException {
        Object component;
        if (propertyValue == null) {
            return null;
        }
        Class<?> type = setter.getParameterTypes()[0];
        String typeName = type.getName();
        Object result = BeanPropertyComponentAdapter.convert(typeName, propertyValue, Thread.currentThread().getContextClassLoader());
        if (result == null && container != null && (component = container.getComponentInstance(propertyValue)) != null && type.isAssignableFrom(component.getClass())) {
            return component;
        }
        return result;
    }

    public static Object convert(String typeName, String value, ClassLoader classLoader) throws ClassNotFoundException {
        if (typeName.equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanPropertyComponentAdapter.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName()) || typeName.equals(Boolean.TYPE.getName())) {
            return Boolean.valueOf(value);
        }
        if (typeName.equals((class$java$lang$Byte == null ? (class$java$lang$Byte = BeanPropertyComponentAdapter.class$("java.lang.Byte")) : class$java$lang$Byte).getName()) || typeName.equals(Byte.TYPE.getName())) {
            return Byte.valueOf(value);
        }
        if (typeName.equals((class$java$lang$Short == null ? (class$java$lang$Short = BeanPropertyComponentAdapter.class$("java.lang.Short")) : class$java$lang$Short).getName()) || typeName.equals(Short.TYPE.getName())) {
            return Short.valueOf(value);
        }
        if (typeName.equals((class$java$lang$Integer == null ? (class$java$lang$Integer = BeanPropertyComponentAdapter.class$("java.lang.Integer")) : class$java$lang$Integer).getName()) || typeName.equals(Integer.TYPE.getName())) {
            return Integer.valueOf(value);
        }
        if (typeName.equals((class$java$lang$Long == null ? (class$java$lang$Long = BeanPropertyComponentAdapter.class$("java.lang.Long")) : class$java$lang$Long).getName()) || typeName.equals(Long.TYPE.getName())) {
            return Long.valueOf(value);
        }
        if (typeName.equals((class$java$lang$Float == null ? (class$java$lang$Float = BeanPropertyComponentAdapter.class$("java.lang.Float")) : class$java$lang$Float).getName()) || typeName.equals(Float.TYPE.getName())) {
            return Float.valueOf(value);
        }
        if (typeName.equals((class$java$lang$Double == null ? (class$java$lang$Double = BeanPropertyComponentAdapter.class$("java.lang.Double")) : class$java$lang$Double).getName()) || typeName.equals(Double.TYPE.getName())) {
            return Double.valueOf(value);
        }
        if (typeName.equals((class$java$lang$Character == null ? (class$java$lang$Character = BeanPropertyComponentAdapter.class$("java.lang.Character")) : class$java$lang$Character).getName()) || typeName.equals(Character.TYPE.getName())) {
            return new Character(value.toCharArray()[0]);
        }
        if (typeName.equals((class$java$lang$String == null ? (class$java$lang$String = BeanPropertyComponentAdapter.class$("java.lang.String")) : class$java$lang$String).getName()) || typeName.equals("string")) {
            return value;
        }
        if (typeName.equals((class$java$io$File == null ? (class$java$io$File = BeanPropertyComponentAdapter.class$("java.io.File")) : class$java$io$File).getName()) || typeName.equals("file")) {
            return new File(value);
        }
        if (typeName.equals((class$java$net$URL == null ? (class$java$net$URL = BeanPropertyComponentAdapter.class$("java.net.URL")) : class$java$net$URL).getName()) || typeName.equals("url")) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw new PicoInitializationException(e);
            }
        }
        if (typeName.equals((class$java$lang$Class == null ? (class$java$lang$Class = BeanPropertyComponentAdapter.class$("java.lang.Class")) : class$java$lang$Class).getName()) || typeName.equals("class")) {
            return classLoader.loadClass(value);
        }
        return null;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

