/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.ComponentMonitor;
import org.picocontainer.defaults.InstantiatingComponentAdapter;
import org.picocontainer.defaults.NotConcreteRegistrationException;
import org.picocontainer.defaults.NullComponentMonitor;
import org.picocontainer.defaults.PicoInvocationTargetInitializationException;
import org.picocontainer.defaults.ThreadLocalCyclicDependencyGuard;
import org.picocontainer.defaults.TooManySatisfiableConstructorsException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class ConstructorInjectionComponentAdapter
extends InstantiatingComponentAdapter {
    private transient List sortedMatchingConstructors;
    private transient Guard instantiationGuard;
    private ComponentMonitor componentMonitor;

    public ConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters, boolean allowNonPublicClasses, ComponentMonitor componentMonitor) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        super(componentKey, componentImplementation, parameters, allowNonPublicClasses);
        this.componentMonitor = componentMonitor;
    }

    public ConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation, Parameter[] parameters) {
        this(componentKey, componentImplementation, parameters, false, NullComponentMonitor.getInstance());
    }

    public ConstructorInjectionComponentAdapter(Object componentKey, Class componentImplementation) throws AssignabilityRegistrationException, NotConcreteRegistrationException {
        this(componentKey, componentImplementation, null);
    }

    protected Constructor getGreediestSatisfiableConstructor(PicoContainer container) throws PicoIntrospectionException, UnsatisfiableDependenciesException, AmbiguousComponentResolutionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Constructor greediestConstructor = null;
        HashSet<Constructor> conflicts = new HashSet<Constructor>();
        HashSet<List<Class>> unsatisfiableDependencyTypes = new HashSet<List<Class>>();
        if (this.sortedMatchingConstructors == null) {
            this.sortedMatchingConstructors = this.getSortedMatchingConstructors();
        }
        int lastSatisfiableConstructorSize = -1;
        for (int i = 0; i < this.sortedMatchingConstructors.size(); ++i) {
            boolean failedDependency = false;
            Constructor constructor = (Constructor)this.sortedMatchingConstructors.get(i);
            Class[] parameterTypes = constructor.getParameterTypes();
            Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
            for (int j = 0; j < currentParameters.length; ++j) {
                if (currentParameters[j].isResolvable(container, this, parameterTypes[j])) continue;
                unsatisfiableDependencyTypes.add(Arrays.asList(parameterTypes));
                failedDependency = true;
                break;
            }
            if (greediestConstructor != null && parameterTypes.length != lastSatisfiableConstructorSize) {
                if (conflicts.isEmpty()) {
                    return greediestConstructor;
                }
                conflicts.add(constructor);
                continue;
            }
            if (!failedDependency && lastSatisfiableConstructorSize == parameterTypes.length) {
                conflicts.add(constructor);
                conflicts.add(greediestConstructor);
                continue;
            }
            if (failedDependency) continue;
            greediestConstructor = constructor;
            lastSatisfiableConstructorSize = parameterTypes.length;
        }
        if (!conflicts.isEmpty()) {
            throw new TooManySatisfiableConstructorsException(this.getComponentImplementation(), conflicts);
        }
        if (greediestConstructor == null && !unsatisfiableDependencyTypes.isEmpty()) {
            throw new UnsatisfiableDependenciesException(this, unsatisfiableDependencyTypes);
        }
        if (greediestConstructor == null) {
            HashSet nonMatching = new HashSet();
            Constructor<?>[] constructors = this.getComponentImplementation().getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                nonMatching.add(constructors[i]);
            }
            throw new PicoInitializationException("Either do the specified parameters not match any of the following constructors: " + ((Object)nonMatching).toString() + " or the constructors were not accessible for '" + this.getComponentImplementation() + "'");
        }
        return greediestConstructor;
    }

    public Object getComponentInstance(PicoContainer container) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        if (this.instantiationGuard == null) {
            this.instantiationGuard = new Guard(){

                public Object run() {
                    Constructor constructor;
                    try {
                        constructor = ConstructorInjectionComponentAdapter.this.getGreediestSatisfiableConstructor(this.guardedContainer);
                    }
                    catch (AmbiguousComponentResolutionException e) {
                        e.setComponent(ConstructorInjectionComponentAdapter.this.getComponentImplementation());
                        throw e;
                    }
                    try {
                        Object[] parameters = ConstructorInjectionComponentAdapter.this.getConstructorArguments(this.guardedContainer, constructor);
                        ConstructorInjectionComponentAdapter.this.componentMonitor.instantiating(constructor);
                        long startTime = System.currentTimeMillis();
                        Object inst = ConstructorInjectionComponentAdapter.this.newInstance(constructor, parameters);
                        ConstructorInjectionComponentAdapter.this.componentMonitor.instantiated(constructor, startTime, System.currentTimeMillis() - startTime);
                        return inst;
                    }
                    catch (InvocationTargetException e) {
                        ConstructorInjectionComponentAdapter.this.componentMonitor.instantiationFailed(constructor, e);
                        if (e.getTargetException() instanceof RuntimeException) {
                            throw (RuntimeException)e.getTargetException();
                        }
                        if (e.getTargetException() instanceof Error) {
                            throw (Error)e.getTargetException();
                        }
                        throw new PicoInvocationTargetInitializationException(e.getTargetException());
                    }
                    catch (InstantiationException e) {
                        ConstructorInjectionComponentAdapter.this.componentMonitor.instantiationFailed(constructor, e);
                        throw new PicoInitializationException("Should never get here");
                    }
                    catch (IllegalAccessException e) {
                        ConstructorInjectionComponentAdapter.this.componentMonitor.instantiationFailed(constructor, e);
                        throw new PicoInitializationException(e);
                    }
                }
            };
        }
        this.instantiationGuard.setArguments(container);
        return this.instantiationGuard.observe(this.getComponentImplementation());
    }

    protected Object[] getConstructorArguments(PicoContainer container, Constructor ctor) {
        Class[] parameterTypes = ctor.getParameterTypes();
        Object[] result = new Object[parameterTypes.length];
        Parameter[] currentParameters = this.parameters != null ? this.parameters : this.createDefaultParameters(parameterTypes);
        for (int i = 0; i < currentParameters.length; ++i) {
            result[i] = currentParameters[i].resolveInstance(container, this, parameterTypes[i]);
        }
        return result;
    }

    private List getSortedMatchingConstructors() {
        ArrayList matchingConstructors = new ArrayList();
        Constructor<?>[] allConstructors = this.getComponentImplementation().getDeclaredConstructors();
        for (int i = 0; i < allConstructors.length; ++i) {
            Constructor<?> constructor = allConstructors[i];
            if (this.parameters != null && constructor.getParameterTypes().length != this.parameters.length || !this.allowNonPublicClasses && (constructor.getModifiers() & 1) == 0) continue;
            matchingConstructors.add(constructor);
        }
        if (this.parameters == null) {
            Collections.sort(matchingConstructors, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((Constructor)arg1).getParameterTypes().length - ((Constructor)arg0).getParameterTypes().length;
                }
            });
        }
        return matchingConstructors;
    }

    private static abstract class Guard
    extends ThreadLocalCyclicDependencyGuard {
        protected PicoContainer guardedContainer;

        private Guard() {
        }

        private void setArguments(PicoContainer container) {
            this.guardedContainer = container;
        }
    }
}

