/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AbstractPicoVisitor;
import org.picocontainer.defaults.ComponentMonitor;
import org.picocontainer.defaults.NullComponentMonitor;

public class LifecycleVisitor
extends AbstractPicoVisitor
implements Serializable {
    private transient Method method;
    private Class type;
    private boolean visitInInstantiationOrder;
    private List componentInstances;
    private ComponentMonitor componentMonitor;

    public LifecycleVisitor(Method method, Class ofType, boolean visitInInstantiationOrder, ComponentMonitor componentMonitor) {
        this.method = method;
        this.type = ofType;
        this.visitInInstantiationOrder = visitInInstantiationOrder;
        this.componentMonitor = componentMonitor;
        this.componentInstances = new ArrayList();
    }

    public LifecycleVisitor(Method method, Class ofType, boolean visiInInstantiationOrder) {
        this(method, ofType, visiInInstantiationOrder, NullComponentMonitor.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object traverse(Object node) {
        this.componentInstances.clear();
        try {
            super.traverse(node);
            if (!this.visitInInstantiationOrder) {
                Collections.reverse(this.componentInstances);
            }
            Iterator iterator = this.componentInstances.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                try {
                    this.componentMonitor.invoking(this.method, o);
                    long startTime = System.currentTimeMillis();
                    this.method.invoke(o, null);
                    this.componentMonitor.invoked(this.method, o, System.currentTimeMillis() - startTime);
                }
                catch (IllegalArgumentException e) {
                    this.componentMonitor.invocationFailed(this.method, o, e);
                    throw new PicoIntrospectionException("Can't call " + this.method.getName() + " on " + o, e);
                }
                catch (IllegalAccessException e) {
                    this.componentMonitor.invocationFailed(this.method, o, e);
                    throw new PicoIntrospectionException("Can't call " + this.method.getName() + " on " + o, e);
                }
                catch (InvocationTargetException e) {
                    this.componentMonitor.invocationFailed(this.method, o, e);
                    throw new PicoIntrospectionException("Failed when calling " + this.method.getName() + " on " + o, e.getTargetException());
                    return Void.TYPE;
                }
            }
        }
        finally {
            this.componentInstances.clear();
        }
    }

    public void visitContainer(PicoContainer pico) {
        this.checkTraversal();
        this.componentInstances.addAll(pico.getComponentInstancesOfType(this.type));
    }

    public void visitComponentAdapter(ComponentAdapter componentAdapter) {
        this.checkTraversal();
    }

    public void visitParameter(Parameter parameter) {
        this.checkTraversal();
    }
}

