/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public class BasicComponentParameter
implements Parameter,
Serializable {
    public static final BasicComponentParameter BASIC_DEFAULT = new BasicComponentParameter();
    private Object componentKey;

    public BasicComponentParameter(Object componentKey) {
        this.componentKey = componentKey;
    }

    public BasicComponentParameter() {
    }

    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        return this.resolveAdapter(container, adapter, expectedType) != null;
    }

    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, expectedType);
        if (componentAdapter != null) {
            return container.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, expectedType);
        if (componentAdapter == null) {
            HashSet<List<Class>> set = new HashSet<List<Class>>();
            set.add(Arrays.asList(expectedType));
            throw new UnsatisfiableDependenciesException(adapter, set);
        }
        componentAdapter.verify(container);
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    private ComponentAdapter resolveAdapter(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter result = this.getTargetAdapter(container, expectedType, adapter);
        if (result == null) {
            return null;
        }
        if (!expectedType.isAssignableFrom(result.getComponentImplementation())) {
            if (expectedType.isPrimitive()) {
                try {
                    Field field = result.getComponentImplementation().getField("TYPE");
                    Class type = (Class)field.get(result.getComponentInstance(null));
                    if (expectedType.isAssignableFrom(type)) {
                        return result;
                    }
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            return null;
        }
        return result;
    }

    private ComponentAdapter getTargetAdapter(PicoContainer container, Class expectedType, ComponentAdapter excludeAdapter) {
        if (this.componentKey != null) {
            return container.getComponentAdapter(this.componentKey);
        }
        if (excludeAdapter == null) {
            return container.getComponentAdapterOfType(expectedType);
        }
        Object excludeKey = excludeAdapter.getComponentKey();
        ComponentAdapter byKey = container.getComponentAdapter(expectedType);
        if (byKey != null) {
            if (byKey.getComponentKey().equals(excludeKey)) {
                return null;
            }
            return byKey;
        }
        List found = container.getComponentAdaptersOfType(expectedType);
        ComponentAdapter exclude = null;
        Iterator iterator = found.iterator();
        while (iterator.hasNext()) {
            ComponentAdapter work = (ComponentAdapter)iterator.next();
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
        }
        found.remove(exclude);
        if (found.size() == 0) {
            if (container.getParent() != null) {
                return container.getParent().getComponentAdapterOfType(expectedType);
            }
            return null;
        }
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = ((ComponentAdapter)found.get(i)).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(expectedType, foundClasses);
    }
}

