/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.monitors;

import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.picocontainer.monitors.AbstractComponentMonitor;

public class WriterComponentMonitor
extends AbstractComponentMonitor {
    private PrintWriter out;

    public WriterComponentMonitor(Writer out) {
        this.out = new PrintWriter(out);
    }

    public void instantiating(Constructor constructor) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: instantiating {0}", new Object[]{constructor}));
    }

    public void instantiated(Constructor constructor, long duration) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: instantiated {0} [{1} ms]", new Object[]{constructor, new Long(duration)}));
    }

    public void instantiationFailed(Constructor constructor, Exception e) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: instantiation failed: {0}, reason: {1}", new Object[]{constructor, e.getMessage()}));
    }

    public void invoking(Method method, Object instance) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: invoking {0} on {1}", new Object[]{method, instance}));
    }

    public void invoked(Method method, Object instance, long duration) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: invoked {0} on {1} [{2} ms]", new Object[]{method, instance, new Long(duration)}));
    }

    public void invocationFailed(Method method, Object instance, Exception e) {
        this.out.println(WriterComponentMonitor.format("PicoContainer: invocation failed: {0} on {1}, reason: {2}", new Object[]{method, instance, e.getMessage()}));
    }
}

