/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.domain.scm;

import org.gradle.api.tasks.Input;

public class ScmPosition {
    private final String revision;
    private final String shortRevision;
    private final String branch;
    private final boolean isClean;

    public ScmPosition(String revision, String shortRevision, String branch, boolean isClean) {
        this.revision = revision;
        this.shortRevision = shortRevision;
        this.branch = branch;
        this.isClean = isClean;
    }

    public ScmPosition(String revision, String shortRevision, String branch) {
        this(revision, shortRevision, branch, true);
    }

    public ScmPosition(String revision, String branch, boolean isClean) {
        this.revision = revision;
        this.shortRevision = revision.length() > 7 ? revision.substring(0, 7) : "";
        this.branch = branch;
        this.isClean = isClean;
    }

    public ScmPosition(String revision, String branch) {
        this(revision, branch, true);
    }

    public String toString() {
        return "ScmPosition[revision = " + this.revision + ", shortRevision = " + this.shortRevision + ", branch = " + this.branch + ", isClean = " + this.isClean + "]";
    }

    @Input
    public String getRevision() {
        return this.revision;
    }

    @Input
    public String getShortRevision() {
        return this.shortRevision;
    }

    @Input
    public String getBranch() {
        return this.branch;
    }

    @Input
    public boolean getIsClean() {
        return this.isClean;
    }
}

