/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.infrastructure.git;

import com.jcraft.jsch.AgentConnector;
import com.jcraft.jsch.AgentIdentityRepository;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JUnixSocketFactory;
import com.jcraft.jsch.PageantConnector;
import com.jcraft.jsch.SSHAgentConnector;
import com.jcraft.jsch.USocketFactory;
import com.jcraft.jsch.UnixDomainSocketFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

class SshAgentIdentityRepositoryFactory {
    private static final Logger logger = Logging.getLogger(SshAgentIdentityRepositoryFactory.class);

    private SshAgentIdentityRepositoryFactory() {
    }

    static Optional<IdentityRepository> tryToCreateIdentityRepository() {
        Optional<AgentConnector> connector = SshAgentIdentityRepositoryFactory.trySshAgent().or(SshAgentIdentityRepositoryFactory::tryPageant);
        Optional<IdentityRepository> optionalIdentityRepository = connector.map(AgentIdentityRepository::new);
        optionalIdentityRepository.ifPresentOrElse(repository -> logger.info("Connected to SSH agent with status: " + SshAgentIdentityRepositoryFactory.statusDescription(repository.getStatus())), () -> logger.warn("No SSH Agent connection could be created. See debug log for details"));
        return optionalIdentityRepository;
    }

    private static Optional<AgentConnector> tryPageant() {
        try {
            return Optional.of(new PageantConnector());
        }
        catch (Exception e) {
            logger.info("Failed to use pageant as identity provider - " + e.getMessage());
            if (logger.isDebugEnabled()) {
                logger.debug(SshAgentIdentityRepositoryFactory.stacktrace(e));
            }
            return Optional.empty();
        }
    }

    private static Optional<AgentConnector> trySshAgent() {
        block7: {
            SSHAgentConnector sshAgentConnector;
            block6: {
                try {
                    JUnixSocketFactory jUnixSocketFactory = new JUnixSocketFactory();
                    sshAgentConnector = new SSHAgentConnector((USocketFactory)jUnixSocketFactory);
                    if (sshAgentConnector.isAvailable()) {
                        return Optional.of(sshAgentConnector);
                    }
                }
                catch (Exception e) {
                    logger.info("Failed to connect to JUnix Socket ssh-agent - " + e.getMessage());
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug(SshAgentIdentityRepositoryFactory.stacktrace(e));
                }
            }
            try {
                UnixDomainSocketFactory unixDomainSocketFactory = new UnixDomainSocketFactory();
                sshAgentConnector = new SSHAgentConnector((USocketFactory)unixDomainSocketFactory);
                if (sshAgentConnector.isAvailable()) {
                    return Optional.of(sshAgentConnector);
                }
            }
            catch (Exception e) {
                logger.info("Failed to connect to Unix Domain Socket ssh-agent - " + e.getMessage());
                if (!logger.isDebugEnabled()) break block7;
                logger.debug(SshAgentIdentityRepositoryFactory.stacktrace(e));
            }
        }
        return Optional.empty();
    }

    private static String stacktrace(Throwable e) {
        StringWriter writer = new StringWriter();
        try (PrintWriter pw = new PrintWriter(writer);){
            e.printStackTrace(pw);
            String string = writer.toString();
            return string;
        }
    }

    private static String statusDescription(int statusCode) {
        if (statusCode == 1) {
            return "Not Running";
        }
        if (statusCode == 0) {
            return "Unavailable";
        }
        if (statusCode == 2) {
            return "Running";
        }
        return "Unknown " + statusCode;
    }
}

