/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.infrastructure.git;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.nio.charset.StandardCharsets;
import org.eclipse.jgit.transport.ssh.jsch.JschConfigSessionFactory;
import org.eclipse.jgit.transport.ssh.jsch.OpenSshConfig;
import org.eclipse.jgit.util.FS;
import pl.allegro.tech.build.axion.release.domain.scm.ScmIdentity;
import pl.allegro.tech.build.axion.release.infrastructure.git.SshAgentIdentityRepositoryFactory;

class SshConnector
extends JschConfigSessionFactory {
    private final ScmIdentity identity;
    private JSch jsch;

    SshConnector(ScmIdentity identity) {
        this.identity = identity;
    }

    protected void configure(OpenSshConfig.Host hc, Session session) {
        session.setConfig("StrictHostKeyChecking", "no");
    }

    protected JSch getJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        if (this.jsch == null) {
            this.jsch = !this.identity.isUseDefault() ? this.createKeyBasedJSch() : this.createSshAgentBasedJSch(hc, fs);
        }
        return this.jsch;
    }

    private JSch createKeyBasedJSch() throws JSchException {
        JSch jsch = new JSch();
        byte[] passPhrase = this.identity.getPassPhrase() != null ? this.identity.getPassPhrase().getBytes(StandardCharsets.UTF_8) : null;
        jsch.addIdentity("key", this.identity.getPrivateKey().getBytes(StandardCharsets.UTF_8), null, passPhrase);
        return jsch;
    }

    private JSch createSshAgentBasedJSch(OpenSshConfig.Host hc, FS fs) throws JSchException {
        boolean sshAgentEnabled;
        JSch ljsch = super.getJSch(hc, fs);
        boolean bl = sshAgentEnabled = !this.identity.isDisableAgentSupport();
        if (sshAgentEnabled) {
            SshAgentIdentityRepositoryFactory.tryToCreateIdentityRepository().ifPresent(r -> ljsch.setIdentityRepository(r));
        }
        return ljsch;
    }
}

