/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.build.axion.release.infrastructure.github;

import groovy.json.JsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class GithubService
implements BuildService<BuildServiceParameters.None>,
AutoCloseable {
    private static final Logger logger = Logging.getLogger(GithubService.class);
    private static final String GITHUB_ACTIONS = "GITHUB_ACTIONS";
    private static final String GITHUB_OUTPUT = "GITHUB_OUTPUT";
    private final Map<String, Map<String, String>> outputs = Collections.synchronizedMap(new LinkedHashMap());

    public void setOutput(String name, String projectName, String value) {
        this.outputs.putIfAbsent(name, Collections.synchronizedMap(new LinkedHashMap()));
        this.outputs.get(name).put(projectName, value);
    }

    @Override
    public void close() {
        if (System.getenv().containsKey(GITHUB_ACTIONS)) {
            this.outputs.forEach((name, valuePerProject) -> {
                List distinctValues = valuePerProject.values().stream().distinct().collect(Collectors.toList());
                if (distinctValues.size() == 1) {
                    String singleValue = (String)distinctValues.get(0);
                    GithubService.writeOutput(name, singleValue);
                } else {
                    String jsonValue = new JsonBuilder(valuePerProject).toString();
                    logger.warn("Multiple values provided for the '{}' GitHub output, it will be formatted as JSON: {}", name, (Object)jsonValue);
                    GithubService.writeOutput(name, jsonValue);
                }
            });
        }
    }

    private static void writeOutput(String name, String value) {
        try {
            Files.write(Paths.get(System.getenv(GITHUB_OUTPUT), new String[0]), String.format("%s=%s\n", name, value).getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            logger.warn("Unable to the set '{}' GitHub output, cause: {}", (Object)name, (Object)e.getMessage());
        }
    }
}

