/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import pl.allegro.tech.hermes.management.config.HealthProperties;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthProblemIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.LaggingIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.MalfunctioningIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.ReceivingMalformedMessagesIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.SlowIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.TimingOutIndicator;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.UnreachableIndicator;

@Configuration
@EnableConfigurationProperties(value={HealthProperties.class})
public class HealthConfiguration {
    @Autowired
    private HealthProperties healthProperties;

    @Bean
    public SubscriptionHealthProblemIndicator laggingIndicator() {
        return new LaggingIndicator(this.healthProperties.getMaxLagInSeconds());
    }

    @Bean
    public SubscriptionHealthProblemIndicator slowIndicator() {
        return new SlowIndicator(this.healthProperties.getMinSubscriptionToTopicSpeedRatio());
    }

    @Bean
    public SubscriptionHealthProblemIndicator unreachableIndicator() {
        return new UnreachableIndicator(this.healthProperties.getMaxOtherErrorsRatio(), this.healthProperties.getMinSubscriptionRateForReliableMetrics());
    }

    @Bean
    public SubscriptionHealthProblemIndicator timingOutIndicator() {
        return new TimingOutIndicator(this.healthProperties.getMaxTimeoutsRatio(), this.healthProperties.getMinSubscriptionRateForReliableMetrics());
    }

    @Bean
    public SubscriptionHealthProblemIndicator malfunctioningIndicator() {
        return new MalfunctioningIndicator(this.healthProperties.getMax5xxErrorsRatio(), this.healthProperties.getMinSubscriptionRateForReliableMetrics());
    }

    @Bean
    public SubscriptionHealthProblemIndicator receivingMalformedMessagesIndicator() {
        return new ReceivingMalformedMessagesIndicator(this.healthProperties.getMax4xxErrorsRatio(), this.healthProperties.getMinSubscriptionRateForReliableMetrics());
    }
}

