/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.kafka.service;

import java.util.function.Consumer;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.domain.message.RetransmissionService;
import pl.allegro.tech.hermes.management.domain.topic.BrokerTopicManagement;
import pl.allegro.tech.hermes.management.domain.topic.SingleMessageReader;

public class BrokersClusterService {
    private final String clusterName;
    private final SingleMessageReader singleMessageReader;
    private final RetransmissionService retransmissionService;
    private final BrokerTopicManagement brokerTopicManagement;

    public BrokersClusterService(String clusterName, SingleMessageReader singleMessageReader, RetransmissionService retransmissionService, BrokerTopicManagement brokerTopicManagement) {
        this.clusterName = clusterName;
        this.singleMessageReader = singleMessageReader;
        this.retransmissionService = retransmissionService;
        this.brokerTopicManagement = brokerTopicManagement;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void manageTopic(Consumer<BrokerTopicManagement> manageFunction) {
        manageFunction.accept(this.brokerTopicManagement);
    }

    public String readMessage(TopicName topicName, Integer partition, Long offset) {
        return this.singleMessageReader.readMessage(topicName, partition, offset);
    }

    public void indicateOffsetChange(TopicName topicName, String subscriptionName, Long timestamp) {
        this.retransmissionService.indicateOffsetChange(topicName, subscriptionName, this.clusterName, timestamp);
    }
}

