/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.kafka.service;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils;
import org.I0Itec.zkclient.ZkClient;
import pl.allegro.tech.hermes.api.RetentionTime;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.config.TopicProperties;
import pl.allegro.tech.hermes.management.domain.topic.BrokerTopicManagement;

public class KafkaBrokerTopicManagement
implements BrokerTopicManagement {
    public static final String RETENTION_MS_PROPERTY = "retention.ms";
    private final TopicProperties topicProperties;
    private final ZkClient client;

    public KafkaBrokerTopicManagement(TopicProperties topicProperties, ZkClient zkClient) {
        this.topicProperties = topicProperties;
        this.client = zkClient;
    }

    @Override
    public void createTopic(TopicName topicName, RetentionTime retentionTime) {
        Properties props = new Properties();
        this.populateRetentionToProperties(retentionTime.getDuration(), props);
        AdminUtils.createTopic((ZkClient)this.client, (String)topicName.qualifiedName(), (int)this.topicProperties.getPartitions(), (int)this.topicProperties.getReplicationFactor(), (Properties)props);
    }

    @Override
    public void removeTopic(TopicName name) {
        AdminUtils.deleteTopic((ZkClient)this.client, (String)name.qualifiedName());
    }

    @Override
    public void updateTopic(TopicName topicName, RetentionTime retentionTime) {
        Properties props = new Properties();
        this.populateRetentionToProperties(retentionTime.getDuration(), props);
        AdminUtils.changeTopicConfig((ZkClient)this.client, (String)topicName.qualifiedName(), (Properties)props);
    }

    private void populateRetentionToProperties(int retentionPolicy, Properties props) {
        props.put(RETENTION_MS_PROPERTY, "" + TimeUnit.DAYS.toMillis(retentionPolicy));
    }
}

