/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.infrastructure.metrics;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.SubscriptionMetrics;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;
import pl.allegro.tech.hermes.infrastructure.zookeeper.counter.DistributedEphemeralCounter;
import pl.allegro.tech.hermes.infrastructure.zookeeper.counter.SharedCounter;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionMetricsRepository;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteClient;
import pl.allegro.tech.hermes.management.infrastructure.graphite.GraphiteMetrics;
import pl.allegro.tech.hermes.management.stub.MetricsPaths;

@Component
public class HybridSubscriptionMetricsRepository
implements SubscriptionMetricsRepository {
    private static final String SUBSCRIPTION_RATE_PATTERN = "sumSeries(%s.consumer.*.meter.%s.%s.%s.m1_rate)";
    private final GraphiteClient graphiteClient;
    private final MetricsPaths metricsPaths;
    private final SharedCounter sharedCounter;
    private final DistributedEphemeralCounter distributedCounter;
    private final ZookeeperPaths zookeeperPaths;

    @Autowired
    public HybridSubscriptionMetricsRepository(GraphiteClient graphiteClient, MetricsPaths metricsPaths, SharedCounter sharedCounter, DistributedEphemeralCounter distributedCounter, ZookeeperPaths zookeeperPaths) {
        this.graphiteClient = graphiteClient;
        this.metricsPaths = metricsPaths;
        this.sharedCounter = sharedCounter;
        this.distributedCounter = distributedCounter;
        this.zookeeperPaths = zookeeperPaths;
    }

    @Override
    public SubscriptionMetrics loadMetrics(TopicName topicName, String subscriptionName) {
        String rateMetric = this.metricPath(topicName, subscriptionName);
        GraphiteMetrics metrics = this.graphiteClient.readMetrics(rateMetric);
        return SubscriptionMetrics.Builder.subscriptionMetrics().withRate(metrics.metricValue(rateMetric)).withDelivered(this.sharedCounter.getValue(this.zookeeperPaths.subscriptionMetricPath(topicName, subscriptionName, "delivered"))).withDiscarded(this.sharedCounter.getValue(this.zookeeperPaths.subscriptionMetricPath(topicName, subscriptionName, "discarded"))).withInflight(this.distributedCounter.getValue(this.zookeeperPaths.consumersPath(), this.zookeeperPaths.subscriptionMetricPathWithoutBasePath(topicName, subscriptionName, "inflight"))).build();
    }

    private String metricPath(TopicName topicName, String subscriptionName) {
        return String.format(SUBSCRIPTION_RATE_PATTERN, this.metricsPaths.prefix(), HermesMetrics.escapeDots((String)topicName.getGroupName()), topicName.getName(), HermesMetrics.escapeDots((String)subscriptionName));
    }
}

