/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import com.wordnik.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Optional;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import pl.allegro.tech.hermes.api.MessageTrace;
import pl.allegro.tech.hermes.api.SentMessageTrace;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionMetrics;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.management.api.validator.ApiPreconditions;
import pl.allegro.tech.hermes.management.domain.subscription.SubscriptionService;
import pl.allegro.tech.hermes.management.domain.topic.TopicService;
import pl.allegro.tech.hermes.management.infrastructure.kafka.MultiDCAwareService;
import pl.allegro.tech.hermes.management.infrastructure.kafka.MultiDCOffsetChangeSummary;
import pl.allegro.tech.hermes.management.infrastructure.time.TimeFormatter;

@Path(value="topics/{topicName}/subscriptions")
public class SubscriptionsEndpoint {
    private final SubscriptionService subscriptionService;
    private final TopicService topicService;
    private final ApiPreconditions preconditions;
    private final MultiDCAwareService multiDCAwareService;
    private final TimeFormatter timeFormatter;

    @Autowired
    public SubscriptionsEndpoint(SubscriptionService subscriptionService, TopicService topicService, ApiPreconditions preconditions, MultiDCAwareService multiDCAwareService, TimeFormatter timeFormatter) {
        this.subscriptionService = subscriptionService;
        this.topicService = topicService;
        this.preconditions = preconditions;
        this.multiDCAwareService = multiDCAwareService;
        this.timeFormatter = timeFormatter;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="List subscriptions", response=List.class, httpMethod="GET")
    public List<String> list(@PathParam(value="topicName") String qualifiedTopicName, @DefaultValue(value="false") @QueryParam(value="tracked") boolean tracked) {
        return tracked ? this.subscriptionService.listTrackedSubscriptionNames(TopicName.fromQualifiedName((String)qualifiedTopicName)) : this.subscriptionService.listSubscriptionNames(TopicName.fromQualifiedName((String)qualifiedTopicName));
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"subscriptionOwner", "admin"})
    @ApiOperation(value="Create subscription", httpMethod="POST")
    public Response create(@PathParam(value="topicName") String qualifiedTopicName, Subscription subscription) {
        this.preconditions.checkConstraints(subscription);
        this.subscriptionService.createSubscription(Subscription.Builder.subscription().applyDefaults().applyPatch(subscription).withTopicName(qualifiedTopicName).build());
        return this.responseStatus(Response.Status.CREATED);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{subscriptionName}")
    @ApiOperation(value="Get subscription details", response=Subscription.class, httpMethod="GET")
    public Subscription get(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="subscriptionName") String subscriptionName) {
        return this.subscriptionService.getSubscriptionDetails(TopicName.fromQualifiedName((String)qualifiedTopicName), subscriptionName);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{subscriptionName}/state")
    @ApiOperation(value="Get subscription state", response=Subscription.State.class, httpMethod="GET")
    public Subscription.State getState(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="subscriptionName") String subscriptionName) {
        return this.subscriptionService.getSubscriptionState(TopicName.fromQualifiedName((String)qualifiedTopicName), subscriptionName);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{subscriptionName}/undelivered/last")
    @ApiOperation(value="Get latest undelivered message", response=SentMessageTrace.class, httpMethod="GET")
    public Response getLatestUndeliveredMessage(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="subscriptionName") String subscriptionName) {
        Optional<SentMessageTrace> result = this.subscriptionService.getLatestUndeliveredMessage(TopicName.fromQualifiedName((String)qualifiedTopicName), subscriptionName);
        return result.isPresent() ? Response.status((Response.Status)Response.Status.OK).entity((Object)result.get()).build() : this.responseStatus(Response.Status.NOT_FOUND);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{subscriptionName}/undelivered")
    @ApiOperation(value="Get latest undelivered messages", response=List.class, httpMethod="GET")
    public Response getLatestUndeliveredMessages(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="subscriptionName") String subscriptionName) {
        List<SentMessageTrace> result = this.subscriptionService.getLatestUndeliveredMessagesTrackerLogs(TopicName.fromQualifiedName((String)qualifiedTopicName), subscriptionName);
        return Response.status((Response.Status)Response.Status.OK).entity(result).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{subscriptionName}/metrics")
    @ApiOperation(value="Get subscription metrics", response=SubscriptionMetrics.class, httpMethod="GET")
    public SubscriptionMetrics getMetrics(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="subscriptionName") String subscriptionName) {
        return this.subscriptionService.getSubscriptionMetrics(TopicName.fromQualifiedName((String)qualifiedTopicName), subscriptionName);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/{subscriptionName}/state")
    @RolesAllowed(value={"subscriptionOwner", "admin"})
    @ApiOperation(value="Update subscription state", httpMethod="PUT")
    public Response updateState(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="subscriptionName") String subscriptionName, Subscription.State state) {
        this.subscriptionService.updateSubscriptionState(TopicName.fromQualifiedName((String)qualifiedTopicName), subscriptionName, state);
        return this.responseStatus(Response.Status.OK);
    }

    @DELETE
    @Path(value="/{subscriptionName}")
    @RolesAllowed(value={"subscriptionOwner", "admin"})
    @ApiOperation(value="Remove subscription", httpMethod="DELETE")
    public Response remove(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="subscriptionName") String subscriptionId) {
        this.subscriptionService.removeSubscription(TopicName.fromQualifiedName((String)qualifiedTopicName), subscriptionId);
        return this.responseStatus(Response.Status.OK);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/{subscriptionName}")
    @RolesAllowed(value={"subscriptionOwner", "admin"})
    @ApiOperation(value="Update subscription", httpMethod="PUT")
    public Response update(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="subscriptionName") String subscriptionName, Subscription subscription) {
        this.subscriptionService.updateSubscription(Subscription.Builder.subscription().withTopicName(qualifiedTopicName).withName(subscriptionName).applyPatch(subscription).build());
        return this.responseStatus(Response.Status.OK);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{subscriptionName}/retransmission")
    @RolesAllowed(value={"subscriptionOwner", "admin"})
    @ApiOperation(value="Update subscription offset", httpMethod="PUT")
    public Response retransmit(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="subscriptionName") String subscriptionName, @DefaultValue(value="false") @QueryParam(value="dryRun") boolean dryRun, @NotEmpty String formattedTime) {
        MultiDCOffsetChangeSummary summary = this.multiDCAwareService.moveOffset(this.topicService.getTopicDetails(TopicName.fromQualifiedName((String)qualifiedTopicName)), subscriptionName, this.timeFormatter.parse(formattedTime), dryRun);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)summary).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{subscriptionName}/events/{messageId}/trace")
    public Response getMessageTrace(@PathParam(value="topicName") String qualifiedTopicName, @PathParam(value="subscriptionName") String subscriptionName, @PathParam(value="messageId") String messageId) {
        List<MessageTrace> status = this.subscriptionService.getMessageStatus(qualifiedTopicName, subscriptionName, messageId);
        return Response.status((Response.Status)Response.Status.OK).entity(status).build();
    }

    private Response responseStatus(Response.Status responseStatus) {
        return Response.status((Response.Status)responseStatus).build();
    }
}

